/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JButton;

class FormInputButton
extends JButton
implements ObjectPainter,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;

    FormInputButton(DocView docView, DElement dElement, String string) {
        super(string);
        this.docView = docView;
        this.element = (DInputElement)dElement;
        String string2 = this.element.getValue();
        if (string2 != null) {
            this.setText(string2);
        }
        this.checkAttributes();
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        String string = this.element.getValue();
        if (string != null && !string.equals(this.getText())) {
            this.setText(string);
            this.box.invalidate();
            this.box.reqReflow();
        } else {
            this.checkAttributes();
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }
}

