/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.awt.DocPanel;
import ice.pilots.html4.awt.EmbeddedObjectContainer;
import ice.pilots.html4.awt.FormInputButton;
import ice.pilots.html4.awt.FormInputCheckbox;
import ice.pilots.html4.awt.FormInputText;
import ice.pilots.html4.awt.FormInputUpload;
import ice.pilots.html4.awt.FormSelectChoice;
import ice.pilots.html4.awt.FormSelectList;
import ice.pilots.html4.awt.FormTextArea;
import ice.pilots.html4.awt.PanePanel;
import ice.pilots.html4.awt.Scroller;
import ice.pilots.html4.awt.TheFactory;
import ice.storm.ViewportLayoutManager;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.w3c.dom.events.EventListener;

final class DocView
extends DocPaneXml
implements AdjustmentListener {
    TheFactory factory;
    PanePanel _panePanel;
    Scrollbar vbar;
    Scrollbar hbar;
    DocPanel docPanel;
    private boolean cursorChange = true;
    long repaintTimeout;
    private ScrollHandler scrollHandler;
    private boolean _doAutoRepaint = true;
    private boolean scrollbarEast = true;
    private final HashArray cgs = new HashArray();
    private final HashArray cgs_none = new HashArray();

    DocView(TheFactory theFactory) {
        this.factory = theFactory;
    }

    protected void init(int n) {
        boolean bl;
        this._panePanel = new PanePanel(this);
        this._panePanel.setLayout(new BorderLayout());
        this.docPanel = new DocPanel(this);
        this.repaintTimeout = Defs.sysPropertyInt("ice.pilots.html4.awt.repaintTimeout", 200);
        boolean bl2 = bl = !Defs.sysPropertyBoolean("ice.browser.pjava");
        if (bl) {
            bl = Defs.sysPropertyBoolean("ice.pilots.html4.scrollbars", true);
        }
        boolean bl3 = this.cursorChange = !Defs.sysPropertyBoolean("ice.pilots.html4.cssCursor");
        if (bl && n != 2) {
            this.vbar = new Scrollbar(1);
            this.hbar = new Scrollbar(0);
        }
        this._panePanel.add((Component)this.docPanel, "Center");
        if (this.vbar != null) {
            this._panePanel.add((Component)this.vbar, "East");
            this._panePanel.add((Component)this.hbar, "South");
            this.vbar.addAdjustmentListener(this);
            this.hbar.addAdjustmentListener(this);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
    }

    public void updateScrollbars(boolean bl) {
        if (this.vbar == null) {
            return;
        }
        if (bl) {
            if (this.scrollbarEast) {
                this._panePanel.remove(this.vbar);
                this._panePanel.add((Component)this.vbar, "West");
                this.scrollbarEast = false;
            }
        } else if (!this.scrollbarEast) {
            this._panePanel.remove(this.vbar);
            this._panePanel.add((Component)this.vbar, "East");
            this.scrollbarEast = true;
        }
    }

    public int getScrollX() {
        return this.docPanel.sx;
    }

    public int getScrollY() {
        return this.docPanel.sy;
    }

    public int getPaneWidth() {
        return this.docPanel.getSize().width;
    }

    public int getPaneHeight() {
        return this.docPanel.getSize().height;
    }

    public void setScrollPosition(int n, int n2) {
        if (!this.canScroll(n, n2)) {
            return;
        }
        if (this.vbar != null) {
            this.hbar.setValue(n);
            this.vbar.setValue(n2);
            this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
        } else {
            int n3 = this.getScrollMaxX();
            int n4 = this.getScrollMaxY();
            if (n < 0) {
                n = 0;
            } else if (n >= n3) {
                n = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n4) {
                n2 = n4;
            }
            this.docPanel.scroll(n, n2);
        }
    }

    public void setPaneBounds(int n, int n2, int n3, int n4) {
        this._panePanel.setBounds(n, n2, n3, n4);
    }

    public void revalidate() {
        this.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                DocView.this.do_revalidate();
            }
        }, 0L);
    }

    void do_revalidate() {
        this.docPanel.invalidate();
        if (this._panePanel.getParent() != null) {
            this._panePanel.validate();
            this.docPanel.repaint();
        }
    }

    public void reqRepaint() {
        this.docPanel.repaint();
    }

    public void reqRepaint(int n, int n2, int n3, int n4) {
        n2 -= this.getScrollY();
        if ((n -= this.getScrollX()) < 0) {
            if (n + n3 <= 0) {
                return;
            }
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            if (n2 + n4 <= 0) {
                return;
            }
            n4 += n2;
            n2 = 0;
        }
        int n5 = this.getPaneWidth();
        int n6 = this.getPaneHeight();
        if (n >= n5 || n2 >= n6) {
            return;
        }
        if (n + n3 > n5) {
            n3 = n5 - n;
        }
        if (n2 + n4 > n6) {
            n4 = n6 - n2;
        }
        if (n3 > 0 && n4 > 0) {
            this.docPanel.preventOptimisedPaintOnce = true;
            this.docPanel.repaint(n, n2, n3, n4);
        }
    }

    public void reqClear() {
        this.docPanel.removeAll();
        this.docPanel.sy = 0;
        this.docPanel.sx = 0;
        this.docPanel.nsy = 0;
        this.docPanel.nsx = 0;
        if (this.vbar != null) {
            this.vbar.setValue(0);
            this.hbar.setValue(0);
        }
    }

    public void setAutoRepaint(boolean bl) {
        this._doAutoRepaint = bl;
    }

    public boolean doesAutoRepaint() {
        return this._doAutoRepaint;
    }

    public void setCursor(int n) {
        Cursor cursor;
        if (this.cursorChange && (cursor = Cursor.getPredefinedCursor(n)) != null && cursor != this.docPanel.getCursor()) {
            this.docPanel.setCursor(cursor);
        }
    }

    public Image createImage(int n, int n2) {
        return this._panePanel.createImage(n, n2);
    }

    protected Component getPaneComponent() {
        return this._panePanel;
    }

    protected ObjectPainter createFormControl(DElement dElement) {
        Component component = null;
        String string = dElement.getLocalName();
        if (string.equalsIgnoreCase("input")) {
            String string2 = dElement.getAttribute("type");
            if (string2 == null || string2.equalsIgnoreCase("text")) {
                component = new FormInputText(this, dElement);
            } else if (string2.equalsIgnoreCase("password")) {
                component = new FormInputText(this, dElement);
                ((TextField)component).setEchoChar('*');
            } else if (string2.equalsIgnoreCase("button")) {
                component = new FormInputButton(this, dElement, "button");
            } else if (string2.equalsIgnoreCase("submit")) {
                component = new FormInputButton(this, dElement, "submit");
            } else if (string2.equalsIgnoreCase("reset")) {
                component = new FormInputButton(this, dElement, "reset");
            } else if (string2.equalsIgnoreCase("file")) {
                component = new FormInputUpload(this, dElement);
            } else if (string2.equalsIgnoreCase("checkbox")) {
                component = new FormInputCheckbox(this, dElement, null);
            } else if (string2.equalsIgnoreCase("radio")) {
                CheckboxGroup checkboxGroup = null;
                Checkbox checkbox = null;
                String string3 = dElement.getAttribute("name");
                if (string3 != null) {
                    checkbox = (Checkbox)this.cgs_none.get(string3);
                    checkboxGroup = (CheckboxGroup)this.cgs.get(string3);
                    if (checkboxGroup == null) {
                        checkboxGroup = new CheckboxGroup();
                        checkbox = new Checkbox();
                        checkbox.setCheckboxGroup(checkboxGroup);
                        this.cgs.put(string3, (Object)checkboxGroup);
                        this.cgs_none.put(string3, (Object)checkbox);
                    }
                }
                component = new FormInputCheckbox(this, dElement, checkbox);
                if (checkboxGroup != null) {
                    ((Checkbox)component).setCheckboxGroup(checkboxGroup);
                }
            }
        } else if (string.equalsIgnoreCase("textarea")) {
            component = new FormTextArea(this, dElement);
        } else if (string.equalsIgnoreCase("select")) {
            int n = dElement.getAttributeAsInt("size");
            component = n <= 1 ? new FormSelectChoice(this, dElement) : new FormSelectList(this, dElement, n);
        }
        if (component != null) {
            this.docPanel.add(component);
        }
        return component;
    }

    protected ObjectPainter createScroller() {
        Scroller scroller = new Scroller(this);
        this.docPanel.add(scroller);
        return scroller;
    }

    protected Container createEmbeddedContainer(EmbeddedObject embeddedObject, Component component) {
        EmbeddedObjectContainer embeddedObjectContainer = new EmbeddedObjectContainer(embeddedObject);
        embeddedObjectContainer.setLayout(new ViewportLayoutManager(embeddedObject));
        ((Component)embeddedObjectContainer).setSize(embeddedObject.getPrefWidth(), embeddedObject.getPrefHeight());
        embeddedObjectContainer.add(component);
        this.docPanel.add(embeddedObjectContainer);
        this.postValidate(embeddedObjectContainer.getParent());
        return embeddedObjectContainer;
    }

    protected Component createFramesDividerComponent() {
        Panel panel = new Panel();
        panel.setBackground(new Color(200, 200, 200));
        return panel;
    }

    protected void checkAwtTree(ObjectBox objectBox, Component component) {
        if (objectBox == null) {
            return;
        }
        ScrollBox scrollBox = objectBox.getAncestorScrollBox();
        if (scrollBox == null) {
            if (this.docPanel != component.getParent()) {
                this.docPanel.add(component);
            }
        } else {
            ObjectBox objectBox2 = scrollBox.getObjectBox();
            ObjectPainter objectPainter = objectBox2.getObjectPainter();
            if (objectPainter instanceof Scroller) {
                Scroller scroller = (Scroller)objectPainter;
                scroller.getView().add(component);
            }
        }
    }

    boolean onComponentEvent(Component component, AWTEvent aWTEvent) {
        return this.onComponentEvent(component, aWTEvent, null);
    }

    boolean onComponentEvent(Component component, AWTEvent aWTEvent, EventListener eventListener) {
        if (!this.checkDocumentId()) {
            return false;
        }
        int n = aWTEvent.getID();
        if (500 <= n && n <= 506) {
            return this.onComponentMouseEvent(component, n, (MouseEvent)aWTEvent, eventListener);
        }
        if (400 <= n && n <= 402) {
            return this.onComponentKeyEvent(component, n, (KeyEvent)aWTEvent, eventListener);
        }
        if (1004 == n) {
            this.notifyFocusGain();
        } else if (1005 == n) {
            this.notifyFocusLost();
        }
        return true;
    }

    private boolean onComponentMouseEvent(Component component, int n, MouseEvent mouseEvent, EventListener eventListener) {
        DOMUIEvent dOMUIEvent = this._translateMouseEvent(n, mouseEvent);
        if (dOMUIEvent == null) {
            return true;
        }
        return this.uiEvent(dOMUIEvent, mouseEvent, eventListener);
    }

    private DOMUIEvent _translateMouseEvent(int n, MouseEvent mouseEvent) {
        DOMUIEvent dOMUIEvent = null;
        int n2 = this._translateX(mouseEvent);
        int n3 = this._translateY(mouseEvent);
        int n4 = -1;
        switch (n) {
            case 504: {
                n4 = 5;
                break;
            }
            case 505: {
                n4 = 7;
                break;
            }
            case 500: {
                if (mouseEvent.getSource() != this.docPanel) break;
                this.docPanel.requestFocus();
                break;
            }
            case 501: {
                n4 = 3;
                break;
            }
            case 502: {
                n4 = 4;
                break;
            }
            case 503: 
            case 506: {
                n4 = 6;
            }
        }
        if (n4 >= 0) {
            dOMUIEvent = this.createDomUIEvent(n4);
            dOMUIEvent.setClientCoords(n2, n3, this.docPanel.sx, this.docPanel.sy);
            try {
                Component component = mouseEvent.getComponent();
                if (component.isShowing()) {
                    Point point = component.getLocationOnScreen();
                    dOMUIEvent.setScreenCoords(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dOMUIEvent;
    }

    private int _translateX(MouseEvent mouseEvent) {
        int n = 0;
        Component component = mouseEvent.getComponent();
        while (component != null && component != this.docPanel) {
            Point point = component.getLocation();
            n += point.x;
            component = component.getParent();
        }
        return mouseEvent.getX() + n;
    }

    private int _translateY(MouseEvent mouseEvent) {
        int n = 0;
        Component component = mouseEvent.getComponent();
        while (component != null && component != this.docPanel) {
            Point point = component.getLocation();
            n += point.y;
            component = component.getParent();
        }
        return mouseEvent.getY() + n;
    }

    private boolean onComponentKeyEvent(Component component, int n, KeyEvent keyEvent, EventListener eventListener) {
        return this.processAwtKeyEvent(component, keyEvent, eventListener);
    }

    private void postValidate(final Component component) {
        Runnable runnable = new Runnable(){

            public void run() {
                component.validate();
            }
        };
        this.getPilot().getStorm().runOnEventThreadLater(runnable, 100L);
    }

    void postShowChildren(final DocPanel docPanel) {
        Runnable runnable = new Runnable(){

            public void run() {
                docPanel.showChildren();
            }
        };
        this.getPilot().getStorm().runOnEventThreadLater(runnable, this.repaintTimeout);
    }

    protected void onNodeSelectCall(DNode dNode) {
        Component component;
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component && (component = (Component)((Object)objectPainter)) instanceof TextComponent) {
            ((TextComponent)component).selectAll();
        }
    }

    protected void onNodeBlurEvent(DOMUIEvent dOMUIEvent, DNode dNode) {
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component) {
            ((Component)((Object)objectPainter)).getParent().requestFocus();
        }
    }

    protected void onNodeFocusEvent(DOMUIEvent dOMUIEvent, DNode dNode) {
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component) {
            ((Component)((Object)objectPainter)).requestFocus();
        }
    }
}

