/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.Nbrs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.ScrollBox;
import ice.storm.DocPane;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class TheView
implements AbstractView,
Nbrs {
    private DDocument doc;
    CSSLayout cssLayout;
    private final Vector clickTargets = new Vector(5);

    TheView(DDocument dDocument, CSSLayout cSSLayout) {
        this.doc = dDocument;
        this.cssLayout = cSSLayout;
    }

    public void reqReflow() {
        this.cssLayout.refresh();
    }

    public DocumentView getDocument() {
        return this.doc;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public FocusManager getFocusManager() {
        return this.cssLayout.getFocusManager();
    }

    public int getWidth() {
        return this.cssLayout.getWidth();
    }

    public int getHeight() {
        return this.cssLayout.getHeight();
    }

    public void setZoom(int n) {
        this.cssLayout.setLayoutZoom(n);
    }

    public int getZoom() {
        return this.cssLayout.getLayoutZoom();
    }

    int getViewWidth() {
        return this.getDocPane().getPaneWidth();
    }

    int getViewHeight() {
        return this.getDocPane().getPaneHeight();
    }

    public DNode getDomNodeAt(int n, int n2, int n3, int n4, Point point) {
        CSSBox cSSBox = this.cssLayout.getBoxAt(n, n2, n3, n4, point);
        if (cSSBox != null) {
            DDocument dDocument;
            Node node;
            DImageElement dImageElement;
            String string;
            DNode dNode = cSSBox.getDomNode();
            if (dNode instanceof DImageElement && (string = (dImageElement = (DImageElement)dNode).getAttribute(112)) != null && string.length() > 1 && (node = (dDocument = dImageElement.getOwnerDDocument()).getMaps().namedItem(string.substring(1))) instanceof DMapElement) {
                DMapElement dMapElement = (DMapElement)node;
                int n5 = 0;
                while (n5 < dMapElement.getAreas().getLength()) {
                    DAreaElement dAreaElement = (DAreaElement)dMapElement.getAreas().item(n5);
                    if (dAreaElement.isInside(point.x, point.y, 1, 1)) {
                        return dAreaElement;
                    }
                    ++n5;
                }
            }
            return dNode;
        }
        return null;
    }

    public void findBoundingBox(DNode dNode, Rectangle rectangle) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            if (dNode instanceof DAreaElement) {
                Object object;
                Nbrs nbrs;
                DAreaElement dAreaElement = (DAreaElement)dNode;
                DMapElement dMapElement = (DMapElement)dAreaElement.getParentNode();
                if (dMapElement == null) {
                    return;
                }
                String string = dMapElement.getName();
                if (string == null) {
                    return;
                }
                DDocument dDocument = dAreaElement.getOwnerDDocument();
                HTMLCollection hTMLCollection = dDocument.getImages();
                Nbrs nbrs2 = null;
                int n = 0;
                while (n < hTMLCollection.getLength()) {
                    nbrs = (DImageElement)hTMLCollection.item(n);
                    object = ((DElement)nbrs).getAttribute(112);
                    if (object != null && ((String)object).length() > 1 && ((String)object).substring(1).equals(string)) {
                        nbrs2 = nbrs;
                        break;
                    }
                    ++n;
                }
                if (nbrs2 == null) {
                    return;
                }
                nbrs = this.cssLayout.findCSSBox((DNode)nbrs2);
                if (nbrs == null) {
                    return;
                }
                ((CSSBox)nbrs).findBoundingBox(rectangle);
                object = dAreaElement.getBoundingAWTShape(rectangle.x, rectangle.y);
                rectangle.setBounds(object.getBounds());
            } else {
                cSSBox.findBoundingBox(rectangle);
            }
            --rectangle.width;
            --rectangle.height;
        }
    }

    public ObjectPainter getNodePainter(DNode dNode) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            if (cSSBox instanceof InlineBox) {
                InlineBox inlineBox = (InlineBox)cSSBox;
                cSSBox = inlineBox.first;
                while (cSSBox != null) {
                    if (cSSBox instanceof ObjectBox) {
                        ObjectBox objectBox = (ObjectBox)cSSBox;
                        return objectBox.getObjectPainter();
                    }
                    cSSBox = cSSBox.next;
                }
            }
            if (cSSBox instanceof ObjectBox) {
                Debug.bug();
            }
        }
        return null;
    }

    public ObjectPainter getNodeScroller(DNode dNode) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        while (cSSBox != null) {
            if (cSSBox instanceof ScrollBox) {
                ScrollBox scrollBox = (ScrollBox)cSSBox;
                ObjectBox objectBox = scrollBox.getObjectBox();
                return objectBox.getObjectPainter();
            }
            cSSBox = cSSBox.parentBox;
        }
        return null;
    }

    DElement getOffsetParent(DNode dNode) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox = cSSBox.parentBox;
            while (cSSBox != null) {
                DElement dElement = cSSBox.element;
                if (dElement == null) break;
                if (cSSBox instanceof PositionedBox || dElement.tagId == 13) {
                    return dElement;
                }
                if (dElement.tagId == 79 || dElement.tagId == 81) {
                    return dElement;
                }
                cSSBox = cSSBox.parentBox;
            }
        }
        return null;
    }

    int getOffsetLeft(DNode dNode) {
        return this.getOffsetLeftOrTop(dNode, true);
    }

    int getOffsetTop(DNode dNode) {
        return this.getOffsetLeftOrTop(dNode, false);
    }

    private int getOffsetLeftOrTop(DNode dNode, boolean bl) {
        int n = 0;
        Rectangle rectangle = new Rectangle();
        this.findBoundingBox2(dNode, rectangle);
        n = bl ? rectangle.x : rectangle.y;
        DElement dElement = this.getOffsetParent(dNode);
        if (dElement != null && dElement.tagId != 13) {
            this.findBoundingBox2(dElement, rectangle);
            n = bl ? (n -= rectangle.x) : (n -= rectangle.y);
        }
        return n;
    }

    void findBoundingBox2(DNode dNode, Rectangle rectangle) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox.findBoundingBox(rectangle);
        } else if (dNode.tagId == 13) {
            rectangle.width = this.getViewWidth();
            rectangle.height = this.getViewHeight();
        } else {
            rectangle.width = 108;
            rectangle.height = 24;
        }
    }

    public void findPosition(DNode dNode, Point point) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox.findAbsolutePosition(point);
        }
    }

    void processFocusCall(DElement dElement) {
        FocusManager focusManager;
        if (dElement.isFocusable() && (focusManager = this.getFocusManager()) != null) {
            focusManager.setFocusedBox(dElement);
        }
    }

    void processBlurCall(DNode dNode) {
        FocusManager focusManager = this.getFocusManager();
        if (focusManager != null) {
            focusManager.setFocusedBox(null);
        }
    }

    void processSelectCall(DNode dNode) {
        this.cssLayout.docPane.onNodeSelectCall(dNode);
    }

    void processClickCall(DNode dNode) {
        DOMEvent dOMEvent = this.doc.createDOMEvent(1, dNode);
        if (!this.doc.pilot.getStorm().isEventThread()) {
            this.doc.processEventLater(dOMEvent, 0L);
        } else if (!this.clickTargets.contains(dNode)) {
            this.clickTargets.addElement(dNode);
            try {
                this.doc.processEvent(dOMEvent);
                Object var4_3 = null;
                this.clickTargets.removeElementAt(this.clickTargets.size() - 1);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.clickTargets.removeElementAt(this.clickTargets.size() - 1);
                throw throwable;
            }
        }
    }
}

