/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.storm.StormPrinter;
import ice.util.Defs;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

class ThePrinter
extends CSSLayout
implements StormPrinter {
    private int pageWidth;
    private int pageHeight;
    private int startPageY = -1;
    private int endPageY = 0;
    private boolean done = false;
    private int startx = 12;
    private int starty = 12;
    private Vector naturalPageBreaks = new Vector();
    private Vector forcedPageBreaks = new Vector();

    ThePrinter(StormData stormData, DDocument dDocument, CSSMatcher cSSMatcher) {
        super(stormData, dDocument, cSSMatcher);
        this.inPrintMode = true;
        this.doc = dDocument;
        this.setPrintBack(Defs.sysPropertyBoolean("ice.pilots.html4.printBackgrounds"));
    }

    public void setPageSize(int n, int n2) {
        this.startPageY = -1;
        this.endPageY = 0;
        this.done = false;
        this.pageWidth = n - 20;
        this.pageHeight = n2 - 20;
        this.layout(this.pageWidth, this.pageHeight);
        this.record_r(this.topBox);
        int n3 = this.naturalPageBreaks.size() - 1;
        while (n3 >= 0) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                Integer n6 = (Integer)this.naturalPageBreaks.elementAt(n4);
                Integer n7 = (Integer)this.naturalPageBreaks.elementAt(n4 + 1);
                int n8 = n6;
                if (n8 > (n5 = n7.intValue())) {
                    this.naturalPageBreaks.removeElementAt(n4);
                    this.naturalPageBreaks.insertElementAt(new Integer(n5), n4);
                    this.naturalPageBreaks.removeElementAt(n4 + 1);
                    this.naturalPageBreaks.insertElementAt(new Integer(n8), n4 + 1);
                    bl = true;
                }
                ++n4;
            }
            if (!bl) break;
            --n3;
        }
    }

    public int getZoom() {
        return this.getLayoutZoom();
    }

    public void setZoom(int n) {
        if (n != this.getZoom()) {
            this.setLayoutZoom(n);
            if (this.pageWidth > 0) {
                this.setPageSize(this.pageWidth + 20, this.pageHeight + 20);
            }
        }
    }

    private void record_r(CSSBox cSSBox) {
        block11: {
            Point point;
            block10: {
                if (!(cSSBox instanceof TableBox)) break block10;
                TableBox tableBox = (TableBox)cSSBox;
                CSSBox cSSBox2 = tableBox.getfirstRowGroup();
                while (cSSBox2 != null && cSSBox2 instanceof TableRowGroupBox) {
                    CSSBox cSSBox3 = ((TableRowGroupBox)cSSBox2).firstRow;
                    while (cSSBox3 != null) {
                        Point point2 = new Point();
                        cSSBox3.findAbsolutePosition(point2);
                        this.naturalPageBreaks.addElement(new Integer(point2.y));
                        this.naturalPageBreaks.addElement(new Integer(point2.y + cSSBox3.height));
                        CSSBox cSSBox4 = (BlockBox)cSSBox3.getFirstChild();
                        while (cSSBox4 != null) {
                            CSSBox cSSBox5 = cSSBox4.first;
                            while (cSSBox5 != null) {
                                if (cSSBox5 != null && cSSBox5 instanceof TableBox) {
                                    this.record_r(cSSBox5);
                                }
                                cSSBox5 = cSSBox5.next;
                            }
                            cSSBox4 = cSSBox4.next;
                        }
                        cSSBox3 = cSSBox3.next;
                    }
                    cSSBox2 = cSSBox2.next;
                }
                break block11;
            }
            if (!(cSSBox instanceof BlockBox)) break block11;
            BlockBox blockBox = (BlockBox)cSSBox;
            int n = blockBox.css.getPageBreak(0);
            int n2 = blockBox.css.getPageBreak(1);
            if (n != 0 || n2 != 0) {
                point = new Point();
                blockBox.findAbsolutePosition(point);
                point.y -= blockBox.css.border_top_width;
                if (n == 1) {
                    this.forcedPageBreaks.addElement(new Integer(point.y));
                }
                if (n2 == 1) {
                    this.forcedPageBreaks.addElement(new Integer(point.y + blockBox.height));
                }
            }
            point = new Point();
            blockBox.findAbsolutePosition(point);
            point.y -= blockBox.css.border_top_width;
            this.naturalPageBreaks.addElement(new Integer(point.y));
            this.naturalPageBreaks.addElement(new Integer(point.y + blockBox.height));
            if (blockBox.isPureBlock) {
                CSSBox cSSBox6 = blockBox.first;
                while (cSSBox6 != null) {
                    this.record_r(cSSBox6);
                    cSSBox6 = cSSBox6.next;
                }
            }
        }
    }

    private void doList_r(BlockBox blockBox) {
        CSSBox cSSBox = blockBox.first;
        while (cSSBox != null) {
            this.record_r(cSSBox);
            if (cSSBox instanceof BlockBox) {
                BlockBox blockBox2 = (BlockBox)cSSBox;
                CSSBox cSSBox2 = blockBox2.first;
                if (cSSBox2 instanceof BlockBox) {
                    this.doList_r((BlockBox)cSSBox2);
                }
            }
            cSSBox = cSSBox.next;
        }
    }

    public boolean layoutNextPage() {
        if (this.done) {
            return false;
        }
        this.startPageY = this.endPageY;
        this.endPageY = this.findPageBreak(this.startPageY, this.pageHeight);
        int n = this.findPageBreak(this.endPageY, this.pageHeight);
        int n2 = this.findPageBreak(n, this.pageHeight);
        if (n == this.endPageY && n2 == this.endPageY) {
            this.endPageY = this.startPageY + this.pageHeight;
        }
        if (this.endPageY >= this.getHeight()) {
            this.endPageY = this.getHeight();
            this.done = true;
        }
        return true;
    }

    public void printPage(Graphics graphics) {
        Graphics graphics2 = graphics.create(this.startx, this.starty, this.pageWidth, this.pageHeight);
        graphics2.setClip(0, 0, this.pageWidth, this.endPageY - this.startPageY);
        graphics2.translate(0, -this.startPageY);
        this.paint(graphics2);
        graphics2.dispose();
    }

    public void dispose() {
        this.clear();
    }

    public void paintCallback(Graphics graphics, ObjectPainter objectPainter) {
        if (objectPainter instanceof Component) {
            ((Component)((Object)objectPainter)).printAll(graphics);
        } else if (objectPainter instanceof EmbeddedObject) {
            Component component = ((EmbeddedObject)objectPainter).getPilotComponent();
            if (component != null) {
                component.printAll(graphics);
            } else {
                super.paintCallback(graphics, objectPainter);
            }
        } else {
            super.paintCallback(graphics, objectPainter);
        }
    }

    protected void initObjectBox(ObjectBox objectBox, ObjectPainter objectPainter) {
    }

    private int findPageBreak(int n, int n2) {
        if (this.forcedPageBreaks.size() > 0) {
            int n3 = 0;
            while (n3 < this.forcedPageBreaks.size()) {
                Integer n4 = (Integer)this.forcedPageBreaks.elementAt(n3);
                int n5 = n4;
                if (n5 > n && n5 <= n + n2) {
                    return n5;
                }
                ++n3;
            }
            int n6 = this.find_break_r(this.topBox, n, n2);
            if (n6 > n) {
                return n6;
            }
            return n + n2;
        }
        Integer n7 = (Integer)this.naturalPageBreaks.elementAt(this.naturalPageBreaks.size() - 1);
        int n8 = n7;
        int n9 = 0;
        while (n9 < this.naturalPageBreaks.size() - 1) {
            Integer n10 = (Integer)this.naturalPageBreaks.elementAt(n9);
            Integer n11 = (Integer)this.naturalPageBreaks.elementAt(n9 + 1);
            int n12 = n10;
            int n13 = n11;
            if (n12 >= n && n12 < n + n2 && n13 > n + n2 && n13 < n + n2 + n2) {
                return n12;
            }
            ++n9;
        }
        return n + n2;
    }

    int find_break_r(CSSBox cSSBox, int n, int n2) {
        int n3;
        block9: {
            n3 = n;
            if (!(cSSBox instanceof BlockBox)) break block9;
            BlockBox blockBox = (BlockBox)cSSBox;
            if (blockBox.isPureBlock) {
                CSSBox cSSBox2 = blockBox.first;
                while (cSSBox2 != null) {
                    if (cSSBox2.oy + cSSBox2.height > n3) {
                        int n4;
                        if (cSSBox2.oy + cSSBox2.height < n3 + n2) {
                            n4 = cSSBox2.oy + cSSBox2.height;
                            n2 -= n4 - n3;
                            n3 = n4;
                        } else {
                            int n5;
                            n4 = n3 - cSSBox2.oy;
                            int n6 = n2;
                            if (n4 < 0) {
                                n6 += n4;
                                n4 = 0;
                            }
                            if ((n5 = this.find_break_r(cSSBox2, n4, n6)) <= n4) break;
                            n3 += n5 - n4;
                            break;
                        }
                    }
                    cSSBox2 = cSSBox2.next;
                }
            } else {
                int[] nArray = blockBox.lines;
                int n7 = blockBox.sizeLines;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = (nArray[n8 + 2] & 0xFFFF) + (nArray[n8 + 2] >> 16);
                    if (n3 + n9 < n + n2) {
                        n3 += n9;
                        n8 += 3;
                        continue;
                    }
                    break;
                }
            }
        }
        return n3;
    }
}

