/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.TheView;
import java.awt.Rectangle;

public class Search {
    private DDocument doc;
    private CSSLayout cssLayout;
    private int mutation = 0;
    private char[] searchText;
    private char[] lowerCaseSearchText;
    private boolean caseSensetive = false;
    private char[] allChars;
    private int numChars;
    private int[] charIndex;
    private DTextNode[] nodes;
    private int numNodes;
    private int searchPos;

    Search(DDocument dDocument, CSSLayout cSSLayout) {
        this.doc = dDocument;
        this.cssLayout = cSSLayout;
        this.record();
    }

    public void dispose() {
        this.cssLayout.clearSelection();
        this.searchPos = 0;
    }

    public void setSearchPosToStart() {
        this.searchPos = 0;
    }

    public void setSearchText(String string) {
        this.searchText = string.toCharArray();
        this.lowerCaseSearchText = string.toLowerCase().toCharArray();
    }

    public void setMatchCase(boolean bl) {
        this.caseSensetive = bl;
    }

    public boolean getMatchCase() {
        return this.caseSensetive;
    }

    public boolean findNext() {
        if (this.searchText == null) {
            return false;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        int n = 0;
        int n2 = 0;
        n = this.searchPos;
        while (n < this.numChars - this.searchText.length) {
            if (this.caseSensetive) {
                n2 = 0;
                while (n2 < this.searchText.length) {
                    if (this.allChars[n + n2] == this.searchText[n2]) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                n2 = 0;
                while (n2 < this.searchText.length) {
                    char c = this.allChars[n + n2];
                    if ((c = Character.toLowerCase(c)) == this.lowerCaseSearchText[n2]) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            if (n2 == this.searchText.length) {
                this.select(n, n + this.searchText.length);
                this.searchPos = n + 1;
                return true;
            }
            ++n;
        }
        this.cssLayout.clearSelection();
        this.searchPos = 0;
        return false;
    }

    public boolean findPrevious() {
        if (this.searchText == null) {
            return false;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        int n = 0;
        int n2 = 0;
        n = this.searchPos;
        while (n >= 0) {
            if (this.caseSensetive) {
                n2 = 0;
                while (n2 < this.searchText.length) {
                    if (this.allChars[n + n2] == this.searchText[n2]) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                n2 = 0;
                while (n2 < this.searchText.length) {
                    char c = this.allChars[n + n2];
                    if ((c = Character.toLowerCase(c)) == this.lowerCaseSearchText[n2]) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            if (n2 == this.searchText.length) {
                this.select(n, n + this.searchText.length);
                this.searchPos = n - 1;
                return true;
            }
            --n;
        }
        this.cssLayout.clearSelection();
        this.searchPos = this.numChars - this.searchText.length;
        return false;
    }

    public final void selectAll() {
        this.select(0, this.numChars - 1);
    }

    private final void select(int n, int n2) {
        Nbrs nbrs;
        Nbrs nbrs2 = null;
        Nbrs nbrs3 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numNodes) {
            nbrs = this.nodes[n5];
            int n6 = this.charIndex[n5];
            if (n >= n6 && n < n6 + ((DTextNode)nbrs).text.length) {
                nbrs2 = nbrs;
                n3 = n - n6;
            }
            if (n2 >= n6 && n2 < n6 + ((DTextNode)nbrs).text.length) {
                nbrs3 = nbrs;
                n4 = n2 - n6;
            }
            ++n5;
        }
        if (nbrs2 != null && nbrs3 != null) {
            nbrs = (TheView)this.doc.getDefaultView();
            if (nbrs != null) {
                DocPaneXml docPaneXml;
                Rectangle rectangle = new Rectangle();
                ((TheView)nbrs).findBoundingBox((DNode)nbrs2, rectangle);
                if (!(rectangle.width <= 0 || (docPaneXml = this.cssLayout.docPane).isVisibleOnScreen(rectangle.x, rectangle.y) && docPaneXml.isVisibleOnScreen(rectangle.x + rectangle.width, rectangle.y + rectangle.height))) {
                    docPaneXml.setScrollPosition(rectangle.x, rectangle.y);
                }
            }
            this.cssLayout.selection.setRange((DNode)nbrs2, n3, (DNode)nbrs3, n4);
            this.cssLayout.somethingSelected = true;
            this.cssLayout.docPane.reqRepaint();
        }
    }

    private final void record() {
        this.mutation = this.doc.getMutation();
        this.allChars = new char[1024];
        this.numChars = 0;
        this.charIndex = new int[16];
        this.nodes = new DTextNode[16];
        this.numNodes = 0;
        this.record_r((DNode)((Object)this.doc.getDocumentElement()));
    }

    private final void record_r(DNode dNode) {
        if (dNode instanceof DTextNode) {
            Object[] objectArray;
            if (this.numNodes >= this.nodes.length) {
                objectArray = new DTextNode[this.nodes.length * 2];
                System.arraycopy(this.nodes, 0, objectArray, 0, this.numNodes);
                this.nodes = objectArray;
                int[] nArray = new int[this.nodes.length * 2];
                System.arraycopy(this.charIndex, 0, nArray, 0, this.numNodes);
                this.charIndex = nArray;
            }
            this.nodes[this.numNodes] = (DTextNode)dNode;
            this.charIndex[this.numNodes] = this.numChars;
            ++this.numNodes;
            objectArray = ((DTextNode)dNode).text;
            if (this.numChars + objectArray.length >= this.allChars.length) {
                int n = this.allChars.length * 2;
                while (this.numChars + objectArray.length >= n) {
                    n *= 2;
                }
                char[] cArray = new char[n];
                System.arraycopy(this.allChars, 0, cArray, 0, this.allChars.length);
                this.allChars = cArray;
            }
            System.arraycopy(objectArray, 0, this.allChars, this.numChars, objectArray.length);
            this.numChars += objectArray.length;
        } else if (dNode != null) {
            if (dNode.getNameId() == 41) {
                return;
            }
            dNode = dNode.getFirstDChild();
            while (dNode != null) {
                this.record_r(dNode);
                dNode = dNode.next;
            }
        }
    }
}

