/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.LexBase;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.ProgressDetail;
import ice.storm.StormLocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

final class Lex2
extends LexBase {
    private byte[] encodingPrescanBuffer;
    private int encodingPrescanOffset;
    private int encodingPrescanLength;
    private String requestedEncoding;
    private static int ENCODING_SCAN_SIZE = 2048;
    private static final int CHAR_BUFFER_SIZE = 4096;
    String curEncoding;
    private final ProgressDetail progDet = new ProgressDetail();

    Lex2(LexCallback lexCallback) {
        super(lexCallback);
        this.char_buf = new char[4096];
    }

    void appendGeneratedContent(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            stringBuffer.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    public void appendGeneratedContent(String string) {
        int n = string.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            string.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    private void makeRoomForGeneratedContent(int n) {
        int n2 = this.bufEnd + n;
        int n3 = this.char_buf.length;
        if (n2 > n3) {
            int n4 = this.bufEnd - this.mark;
            int n5 = n4 + n;
            if (n5 <= n3) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, n4);
            } else {
                if (n5 > (n3 *= 2)) {
                    n3 = n5;
                }
                char[] cArray = new char[n3];
                System.arraycopy(this.char_buf, this.mark, cArray, 0, n4);
                this.char_buf = cArray;
            }
            this.mark = 0;
            this.bufEnd = n4;
        }
    }

    private boolean isInEncodingPrescan() {
        return this.encodingPrescanOffset >= 0;
    }

    private void resetEncodingPrescan() {
        this.encodingPrescanOffset = 0;
    }

    public void close() throws IOException {
        if (this.encodingPrescanOffset >= 0) {
            this.encodingPrescanOffset = -1;
            this.encodingPrescanBuffer = null;
        }
        super.close();
    }

    public int available() throws IOException {
        if (this.encodingPrescanOffset >= 0) {
            return this.encodingPrescanLength - this.encodingPrescanOffset;
        }
        return super.available();
    }

    public int read() throws IOException {
        if (this.encodingPrescanOffset >= 0) {
            if (this.encodingPrescanOffset != this.encodingPrescanLength) {
                return 0xFF & this.encodingPrescanBuffer[this.encodingPrescanOffset++];
            }
            this.encodingPrescanOffset = -1;
            this.encodingPrescanBuffer = null;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.encodingPrescanOffset >= 0) {
            int n3 = this.encodingPrescanLength - this.encodingPrescanOffset;
            if (n3 != 0) {
                if (n2 > n3) {
                    n2 = n3;
                }
                System.arraycopy(this.encodingPrescanBuffer, this.encodingPrescanOffset, byArray, n, n2);
                this.encodingPrescanOffset += n2;
                return n2;
            }
            this.encodingPrescanOffset = -1;
            this.encodingPrescanBuffer = null;
        }
        return super.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        if (this.encodingPrescanOffset >= 0) {
            int n = this.encodingPrescanLength - this.encodingPrescanOffset;
            if (n != 0) {
                int n2 = (long)n < l ? n : (int)l;
                this.encodingPrescanOffset += n2;
                return n2;
            }
            this.encodingPrescanOffset = -1;
            this.encodingPrescanBuffer = null;
        }
        return super.skip(l);
    }

    void setInputStream(InputStream inputStream, String string) {
        byte[] byArray = new byte[ENCODING_SCAN_SIZE];
        int n = 0;
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, n, ENCODING_SCAN_SIZE - n)) >= 0 && (n += n2) != ENCODING_SCAN_SIZE) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setupEncodingPrescan(byArray, n, inputStream);
        this.setupEncodingConvertion(string);
    }

    protected void readAtLeast(int n) throws IOException {
        int n2 = this.inputReadProgress;
        super.readAtLeast(n);
        this.progDet.length = this.inputReadProgress - n2;
        this.progDet.startpos = this.bufEnd - this.progDet.length;
        this.progDet.buf = this.char_buf;
        this.progDet.enc = this.curEncoding;
        ((LexCallback)this.callback).progress(this.inputReadProgress, this.progDet);
    }

    String getEncoding() {
        return this.curEncoding;
    }

    boolean applyEncodingChange(String string) {
        boolean bl = false;
        if (!string.equals(this.curEncoding) && this.sourceInputStream != null && this.isInEncodingPrescan()) {
            this.requestedEncoding = string;
            bl = true;
        }
        return bl;
    }

    private void doEncodingChange(String string) {
        if (this.sourceInputStream != null && this.isInEncodingPrescan()) {
            this.resetEncodingPrescan();
            this.setupEncodingConvertion(string);
            this.mark = 0;
            this.bufEnd = 0;
            this.lexerState = 0;
            this.done = false;
            this.inputReadProgress = 0;
            this.lineNumber = 0;
        }
    }

    private void setupEncodingPrescan(byte[] byArray, int n, InputStream inputStream) {
        this.encodingPrescanBuffer = byArray;
        this.encodingPrescanLength = n;
        this.sourceInputStream = inputStream;
    }

    private void setupEncodingConvertion(String string) {
        InputStreamReader inputStreamReader = StormLocaleUtils.createInputStreamReader(this, string = Lex2.strip_quotas(string));
        if (inputStreamReader instanceof InputStreamReader) {
            string = inputStreamReader.getEncoding();
        }
        this.curEncoding = string;
        this.setReader(inputStreamReader);
    }

    private static String strip_quotas(String string) {
        if (string != null) {
            int n = string.length();
            if (n == 0) {
                string = null;
            } else {
                char c = string.charAt(0);
                char c2 = string.charAt(n - 1);
                if (c == '\"' || c == '\'' || c2 == '\"' || c2 == '\'') {
                    int n2 = c == '\"' || c == '\'' ? 1 : 0;
                    int n3 = c2 == '\"' || c2 == '\'' ? n - 1 : n;
                    string = n2 >= n3 ? null : string.substring(n2, n3);
                }
            }
        }
        return string;
    }

    protected void restoreBuffer(char[] cArray, int n, int n2) {
        super.restoreBuffer(cArray, n, n2);
        if (this.lexerNestingLevel == 1 && this.requestedEncoding != null) {
            this.doEncodingChange(this.requestedEncoding);
            this.requestedEncoding = null;
        }
    }

    static {
        try {
            String string = System.getProperty("ice.browser.encodingScanSize");
            ENCODING_SCAN_SIZE = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            ENCODING_SCAN_SIZE = 2048;
        }
    }
}

