/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;
import java.awt.Color;

final class HtmlToCss
implements Nbrs {
    private static int NOT_VALID = -12345;

    HtmlToCss() {
    }

    static void apply(DElement dElement, CSSAttribs cSSAttribs, CSSBox cSSBox, int n) {
        switch (dElement.tagId) {
            case 1: {
                char[] cArray;
                Color color;
                DAnchorElement dAnchorElement;
                String string;
                if (dElement.getAttribute(46) == null || (string = (dAnchorElement = (DAnchorElement)dElement).getVisited() ? dElement.doc.getVlinkColor() : dElement.doc.getLinkColor()) == null || (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) == null) break;
                cSSAttribs.color = color;
                break;
            }
            case 5: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                Names names;
                int n2;
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_text_color(dElement, cSSAttribs, 109);
                String string = dElement.getAttribute(11);
                if (string != null && cSSAttribs.background_image == null) {
                    cSSAttribs.background_image = string;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, 58, n)) >= 0) {
                    cSSAttribs.padding_left = cSSAttribs.padding_right = n2;
                }
                if (n2 == 0) {
                    cSSAttribs.margin_right = 0;
                    cSSAttribs.margin_left = 0;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, 57, n)) >= 0) {
                    cSSAttribs.padding_top = cSSAttribs.padding_bottom = n2;
                }
                if (n2 == 0) {
                    cSSAttribs.margin_bottom = 0;
                    cSSAttribs.margin_top = 0;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, (names = dElement.doc.getDom().getStormData().names).getAttrId(3, "topmargin"), n)) >= 0) {
                    cSSAttribs.padding_top = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "bottommargin"), n)) >= 0) {
                    cSSAttribs.padding_bottom = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "leftmargin"), n)) >= 0) {
                    cSSAttribs.padding_left = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "rightmargin"), n)) < 0) break;
                cSSAttribs.padding_right = n2;
                break;
            }
            case 14: {
                String string = dElement.getAttribute(23);
                if (string == null) break;
                if (string.equalsIgnoreCase("left")) {
                    cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 4);
                    break;
                }
                if (string.equalsIgnoreCase("right")) {
                    cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 8);
                    break;
                }
                if (!string.equalsIgnoreCase("both") && !string.equalsIgnoreCase("all")) break;
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | (4 | 8));
                break;
            }
            case 16: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 20: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 21: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 93: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 26: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 31: {
                HtmlToCss.apply_text_color(dElement, cSSAttribs, 27);
                String string = dElement.getAttribute(40);
                if (string != null && !string.equals("")) {
                    cSSAttribs.font_family = cSSAttribs.sdata.fontCache.getFontFamilyId(string);
                }
                if ((string = dElement.getAttribute(100)) == null) break;
                try {
                    char c = string.charAt(0);
                    if (c == '+' || c == '-') {
                        int n3 = CSSUtil.parseInt(string.substring(1));
                        if (c == '-') {
                            n3 = -n3;
                        }
                        cSSAttribs.font_size = cSSAttribs.sdata.fontCache.getFontSizeAbs(n3 += 3, n);
                        break;
                    }
                    int n4 = CSSUtil.parseInt(string);
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    cSSAttribs.font_size = cSSAttribs.sdata.fontCache.getFontSizeAbs(n4, n);
                }
                catch (Exception exception) {}
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 42: {
                cSSAttribs.text_align = 2;
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 46: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 6);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                break;
            }
            case 47: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 45: 
            case 60: {
                String string = dElement.getAttribute("hidden");
                if (string != null && string.equalsIgnoreCase("true")) {
                    cSSAttribs.misc = (byte)(cSSAttribs.misc & ~1);
                }
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                char c;
                String string = dElement.getAttribute(111);
                if (string == null) break;
                int n5 = 99;
                int n6 = string.length();
                if (n6 == 4) {
                    char c2 = string.charAt(0);
                    if (c2 == 'D' || c2 == 'd') {
                        if (CharKit.equalsIgnoreAsciiCase("disc", string)) {
                            n5 = 97;
                        }
                    } else if ((c2 == 'N' || c2 == 'n') && CharKit.equalsIgnoreAsciiCase("none", string)) {
                        n5 = 8;
                    }
                } else if (n6 == 6 && ((c = string.charAt(0)) == 'C' || c == 'c') && CharKit.equalsIgnoreAsciiCase("circle", string)) {
                    n5 = 98;
                }
                cSSAttribs.listStyleType = (byte)n5;
                break;
            }
            case 61: {
                String string = dElement.getAttribute(111);
                if (string == null || string.length() <= 0) break;
                int n7 = string.charAt(0);
                n7 = n7 == 105 ? 102 : (n7 == 73 ? 103 : (n7 == 97 ? 105 : (n7 == 65 ? 107 : 100)));
                cSSAttribs.listStyleType = (byte)n7;
                break;
            }
            case 64: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 79: {
                int n8;
                String string = dElement.getAttribute(11);
                if (string != null) {
                    cSSAttribs.background_image = string;
                }
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                if (dElement.getAttribute(15) != null) {
                    n8 = HtmlToCss.parse_length(dElement, 15, n);
                    if (n8 >= 0) {
                        cSSAttribs.border_spacing_x = n8;
                        cSSAttribs.border_spacing_y = n8;
                    }
                } else if (!dElement.getSynthetic()) {
                    cSSAttribs.border_spacing_x = 3;
                    cSSAttribs.border_spacing_y = 3;
                }
                n8 = 0;
                string = dElement.getAttribute(13);
                if (string != null) {
                    n8 = 1;
                    try {
                        n8 = CSSUtil.parseInt(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cSSAttribs.border_top_style = 155;
                cSSAttribs.border_bottom_style = 155;
                cSSAttribs.border_left_style = 155;
                cSSAttribs.border_right_style = 155;
                cSSAttribs.border_top_width = n8;
                cSSAttribs.border_bottom_width = n8;
                cSSAttribs.border_left_width = n8;
                cSSAttribs.border_right_width = n8;
                break;
            }
            case 80: 
            case 83: 
            case 85: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                break;
            }
            case 81: 
            case 84: {
                String string = dElement.getAttribute(11);
                if (string != null) {
                    cSSAttribs.background_image = string;
                }
                if ((string = dElement.getAttribute(67)) != null) {
                    cSSAttribs.misc = (byte)(cSSAttribs.misc | 8);
                }
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                DElement dElement2 = (DElement)dElement.getParentDNode().getParentDNode().getParentDNode();
                string = dElement2.getAttribute(13);
                int n9 = 0;
                if (string != null) {
                    n9 = 1;
                    try {
                        n9 = CSSUtil.parseInt(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n9 > 0) {
                    cSSAttribs.border_top_style = 154;
                    cSSAttribs.border_bottom_style = 154;
                    cSSAttribs.border_left_style = 154;
                    cSSAttribs.border_right_style = 154;
                    cSSAttribs.border_top_width = 1;
                    cSSAttribs.border_bottom_width = 1;
                    cSSAttribs.border_left_width = 1;
                    cSSAttribs.border_right_width = 1;
                    CSSBox cSSBox2 = cSSBox.getParentBox().getParentBox();
                    Color color = cSSBox2.css.background_color;
                    if (color != null) {
                        cSSAttribs.border_top_color = color;
                        cSSAttribs.border_bottom_color = color;
                        cSSAttribs.border_left_color = color;
                        cSSAttribs.border_right_color = color;
                    }
                }
                if ((n9 = HtmlToCss.parse_length(dElement2, 14, n)) < 0) break;
                cSSAttribs.padding_top = n9;
                cSSAttribs.padding_bottom = n9;
                cSSAttribs.padding_left = n9;
                cSSAttribs.padding_right = n9;
                break;
            }
            case 87: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 29: 
            case 43: 
            case 50: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 91: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
            }
        }
    }

    private static void apply_direction(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(37);
        if (string != null) {
            if (string.equalsIgnoreCase("rtl")) {
                cSSAttribs.directionFlag = 1;
            } else if (string.equalsIgnoreCase("ltr")) {
                cSSAttribs.directionFlag = (byte)2;
            }
        }
    }

    private static void apply_text_align(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(6);
        if (string != null) {
            cSSAttribs.text_align = string.equalsIgnoreCase("right") ? 3 : (string.equalsIgnoreCase("center") || string.equalsIgnoreCase("middle") ? 2 : 1);
        }
    }

    private static void apply_v_align(DElement dElement, CSSAttribs cSSAttribs, int n) {
        String string = dElement.getAttribute(n);
        if (string != null) {
            if (string.equalsIgnoreCase("top")) {
                cSSAttribs.vertical_align_type = 16;
            } else if (string.equalsIgnoreCase("bottom")) {
                cSSAttribs.vertical_align_type = 17;
            } else if (string.equalsIgnoreCase("middle")) {
                cSSAttribs.vertical_align_type = 144;
            } else if (string.equalsIgnoreCase("baseline")) {
                cSSAttribs.vertical_align_type = 140;
            }
        }
    }

    private static void apply_block_align(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(6);
        if (string != null) {
            if (string.equalsIgnoreCase("right")) {
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 2);
            } else if (string.equalsIgnoreCase("left")) {
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 1);
            } else if (string.equalsIgnoreCase("center")) {
                cSSAttribs.misc = (byte)(cSSAttribs.misc | 0x40);
            }
        }
    }

    private static void apply_width_height(DElement dElement, CSSAttribs cSSAttribs, int n) {
        int n2 = HtmlToCss.parse_length(dElement, 119, n);
        if (n2 >= 0) {
            cSSAttribs.width = n2;
            cSSAttribs.percentage_flag &= ~0x100000;
        } else if (n2 != NOT_VALID) {
            cSSAttribs.width = -n2;
            cSSAttribs.percentage_flag |= 0x100000;
        }
        n2 = HtmlToCss.parse_length(dElement, 45, n);
        if (n2 >= 0) {
            cSSAttribs.height = n2;
            cSSAttribs.percentage_flag &= ~8;
        } else if (n2 != NOT_VALID) {
            cSSAttribs.height = -n2;
            cSSAttribs.percentage_flag |= 8;
        }
    }

    private static void apply_vspace_hspace(DElement dElement, CSSAttribs cSSAttribs, int n) {
        int n2 = HtmlToCss.parse_length(dElement, 48, n);
        if (n2 > 0) {
            cSSAttribs.padding_left = cSSAttribs.padding_right = n2;
        }
        if ((n2 = HtmlToCss.parse_length(dElement, 118, n)) > 0) {
            cSSAttribs.padding_top = cSSAttribs.padding_bottom = n2;
        }
    }

    private static void apply_bgcolor(DElement dElement, CSSAttribs cSSAttribs) {
        char[] cArray;
        Color color;
        String string = dElement.getAttribute(12);
        if (string != null && (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) != null) {
            cSSAttribs.background_color = color;
        }
    }

    private static void apply_text_color(DElement dElement, CSSAttribs cSSAttribs, int n) {
        char[] cArray;
        Color color;
        String string = dElement.getAttribute(n);
        if (string != null && (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) != null) {
            cSSAttribs.color = color;
        }
    }

    private static int parse_length(DElement dElement, int n, int n2) {
        int n3;
        block3: {
            n3 = NOT_VALID;
            String string = dElement.getAttribute(n);
            if (string != null) {
                try {
                    n3 = string.endsWith("%") ? -CSSUtil.parseInt(string.substring(0, string.length() - 1)) : CSSUtil.parseInt(string) * n2 >> 8;
                }
                catch (Exception exception) {
                    if (!string.startsWith("60")) break block3;
                    n3 = 60;
                }
            }
        }
        return n3;
    }
}

