/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class FontCache {
    private String baseFontFamily = "SansSerif";
    private int baseFontSize = 9;
    int minFontSize = 4;
    int defaultFontFamily = 0;
    int fallbackFontFamily = 0;
    float DPI = 120.0f;
    private static final int[] fontMuls = new int[]{256, 307, 369, 442, 531, 637, 764, 850};
    private Hashtable fms = new Hashtable();
    private String[] genericToJava = new String[]{"monospace", "Monospaced", "sansserif", "SansSerif", "sans-serif", "SansSerif", "helvetica", "SansSerif", "arial", "SansSerif", "serif", "Serif"};
    private int[] genericToFamilyId;
    private String[] allFamilies;
    private Hashtable familyToId = null;
    boolean initialized = false;
    private static boolean traceFonts = Debug.trace && Defs.sysPropertyBoolean("ice.pilots.html4.traceFonts");
    private static Graphics _printGraphics;

    private static void traceFonts(String[] stringArray) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Known families: " + n);
        int n2 = 0;
        while (n2 != n) {
            stringBuffer.append("\n\t");
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        if (Debug.trace) {
            Debug.trace(stringBuffer.toString());
        }
    }

    private static void traceFontMetrics(FontMetrics fontMetrics) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tfont: ");
        stringBuffer.append(fontMetrics.getFont().toString());
        stringBuffer.append("\n\tascent: ");
        stringBuffer.append(fontMetrics.getAscent());
        stringBuffer.append(", descent: ");
        stringBuffer.append(fontMetrics.getDescent());
        stringBuffer.append(", height: ");
        stringBuffer.append(fontMetrics.getHeight());
        stringBuffer.append(", max-ascent: ");
        stringBuffer.append(fontMetrics.getMaxAscent());
        stringBuffer.append(", max-descent: ");
        stringBuffer.append(fontMetrics.getMaxDescent());
        stringBuffer.append("\n\tmax-advance: ");
        stringBuffer.append(fontMetrics.getMaxAdvance());
        stringBuffer.append(", test-width: ");
        stringBuffer.append(fontMetrics.stringWidth("Hello, world!"));
        if (Debug.trace) {
            Debug.trace(stringBuffer.toString());
        }
    }

    public static void setPrintGraphics(Graphics graphics) {
        _printGraphics = graphics;
    }

    void init() {
        int n;
        if (this.initialized) {
            return;
        }
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        this.DPI = n2;
        if (!this.initJava2Fonts()) {
            this.initJava1Fonts();
        }
        if (traceFonts) {
            FontCache.traceFonts(this.allFamilies);
        }
        this.familyToId = new Hashtable();
        int n3 = 0;
        while (n3 < this.allFamilies.length) {
            this.familyToId.put(CharKit.toLowerCase(this.allFamilies[n3]), new Integer(n3));
            ++n3;
        }
        String string = Defs.sysProperty("ice.pilots.html4.addonFontMapping");
        if (string != null) {
            n = 1;
            int n4 = string.indexOf(44);
            while (n4 > 0) {
                ++n;
                n4 = string.indexOf(44, n4 + 1);
            }
            String[] stringArray = new String[this.genericToJava.length + n];
            System.arraycopy(this.genericToJava, 0, stringArray, 0, this.genericToJava.length);
            int n5 = 0;
            n4 = string.indexOf(44);
            n = this.genericToJava.length;
            while (n4 > 0) {
                stringArray[n++] = CharKit.toLowerCase(string.substring(n5, n4).trim());
                n5 = n4 + 1;
                n4 = string.indexOf(44, n5);
            }
            stringArray[n] = CharKit.toLowerCase(string.substring(n5).trim());
            this.genericToJava = stringArray;
        }
        this.genericToFamilyId = new int[this.genericToJava.length / 2];
        n = 0;
        while (n < this.genericToJava.length) {
            Integer n6 = (Integer)this.familyToId.get(CharKit.toLowerCase(this.genericToJava[n + 1]));
            if (n6 != null) {
                this.genericToFamilyId[n >> 1] = n6;
            }
            n += 2;
        }
        this.initialized = true;
        this.defaultFontFamily = this.getFontFamilyId(this.baseFontFamily);
        this.fallbackFontFamily = this.getFontFamilyId("Serif");
    }

    private void initJava1Fonts() {
        this.allFamilies = Toolkit.getDefaultToolkit().getFontList();
        String string = Defs.sysProperty("ice.pilots.html4.addonFonts");
        if (string != null) {
            int n = 1;
            int n2 = string.indexOf(44);
            while (n2 > 0) {
                ++n;
                n2 = string.indexOf(44, n2 + 1);
            }
            String[] stringArray = new String[this.allFamilies.length + n];
            System.arraycopy(this.allFamilies, 0, stringArray, 0, this.allFamilies.length);
            int n3 = 0;
            n2 = string.indexOf(44);
            n = this.allFamilies.length;
            while (n2 > 0) {
                stringArray[n++] = string.substring(n3, n2).trim();
                n3 = n2 + 1;
                n2 = string.indexOf(44, n3);
            }
            stringArray[n] = string.substring(n3).trim();
            this.allFamilies = stringArray;
        }
    }

    private boolean initJava2Fonts() {
        boolean bl;
        String[] stringArray;
        Object object;
        try {
            object = Class.forName("java.awt.GraphicsEnvironment");
            Method method = ((Class)object).getMethod("getLocalGraphicsEnvironment", null);
            Method method2 = ((Class)object).getMethod("getAvailableFontFamilyNames", null);
            stringArray = method.invoke(null, null);
            this.allFamilies = (String[])method2.invoke((Object)stringArray, null);
        }
        catch (Exception exception) {
            return false;
        }
        object = System.getProperty("java.version");
        boolean bl2 = bl = ((String)object).startsWith("1.1") || ((String)object).startsWith("1.2") || ((String)object).startsWith("1.3");
        if ("Linux".equals(System.getProperty("os.name")) && bl) {
            int n = 0;
            while (n < this.allFamilies.length) {
                if ("Arial".equals(this.allFamilies[n])) {
                    stringArray = new String[this.allFamilies.length - 1];
                    System.arraycopy(this.allFamilies, 0, stringArray, 0, n);
                    if (n < this.allFamilies.length - 1) {
                        System.arraycopy(this.allFamilies, n + 1, stringArray, n, this.allFamilies.length - n - 1);
                    }
                    this.allFamilies = stringArray;
                }
                ++n;
            }
        }
        return true;
    }

    float getScreenResolution() {
        if (!this.initialized) {
            this.init();
        }
        return this.DPI;
    }

    int getFontFamilyId(String string) {
        if (!this.initialized) {
            this.init();
        }
        int n = -1;
        int n2 = string.indexOf(44);
        if (n2 > 0) {
            String string2;
            int n3 = 0;
            while (n2 > 0) {
                string2 = string.substring(n3, n2);
                n = this.mapSingleFontFamily(string2);
                if (n != -1) break;
                n3 = n2 + 1;
                n2 = string.indexOf(44, n3);
            }
            if (n == -1 && n3 < string.length()) {
                string2 = string.substring(n3);
                n = this.mapSingleFontFamily(string2);
            }
        } else {
            n = this.mapSingleFontFamily(string);
        }
        if (n == -1) {
            String string3 = CharKit.toLowerCase(string);
            int n4 = 0;
            while (n4 < this.genericToJava.length) {
                if (string3.indexOf(this.genericToJava[n4]) >= 0) {
                    n = this.genericToFamilyId[n4 >> 1];
                    break;
                }
                n4 += 2;
            }
        }
        if (n == -1) {
            n = this.fallbackFontFamily;
        }
        return n;
    }

    private int mapSingleFontFamily(String string) {
        if ((string = string.trim()).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        string = CharKit.toLowerCase(string);
        if (!(System.getProperty("ice.pilots.html4.ignoreNonGenericFonts") == null || "monospace".equals(string) || "sansserif".equals(string) || "sans-serif".equals(string) || "serif".equals(string))) {
            return -1;
        }
        Integer n = (Integer)this.familyToId.get(string);
        if (n != null) {
            int n2 = n;
            return n2;
        }
        return -1;
    }

    FontMetrics getFontMetrics(CSSAttribs cSSAttribs) {
        Serializable serializable;
        FontMetrics fontMetrics;
        if (!this.initialized) {
            this.init();
        }
        if (_printGraphics != null && (fontMetrics = _printGraphics.getFontMetrics((Font)(serializable = new Font(this.allFamilies[cSSAttribs.font_family], cSSAttribs.font_style, cSSAttribs.font_size)))) != null) {
            return fontMetrics;
        }
        serializable = new Integer((cSSAttribs.font_family << 18) + (cSSAttribs.font_style << 16) + cSSAttribs.font_size);
        fontMetrics = (FontMetrics)this.fms.get(serializable);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        String string = this.allFamilies[cSSAttribs.font_family];
        Font font = new Font(string, cSSAttribs.font_style, cSSAttribs.font_size);
        fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (traceFonts) {
            FontCache.traceFontMetrics(fontMetrics);
        }
        this.fms.put(serializable, fontMetrics);
        return fontMetrics;
    }

    void clear() {
        this.fms.clear();
    }

    void setBaseFontFamily(String string) {
        this.baseFontFamily = string;
        if (this.initialized) {
            this.defaultFontFamily = this.getFontFamilyId(this.baseFontFamily);
        }
    }

    void setBaseFontSize(int n) {
        this.baseFontSize = n;
    }

    void setMinFontSize(int n) {
        this.minFontSize = n;
    }

    int getFontSizeAbs(int n, int n2) {
        if (!this.initialized) {
            this.init();
        }
        if (n < 0) {
            n = 0;
        } else if (n > 7) {
            n = 7;
        }
        n = this.baseFontSize * fontMuls[n] >> 8;
        if (n2 != 256 && (n = n * n2 >> 8) < this.minFontSize) {
            n = this.minFontSize;
        }
        return n;
    }

    int getFontSizeRel(int n, int n2) {
        if (!this.initialized) {
            this.init();
        }
        if (n == 0) {
            return n2;
        }
        if (n < 0) {
            while (n < 0) {
                n2 = n2 * 256 / 307;
                ++n;
            }
        } else if (n > 0) {
            while (n > 0) {
                n2 = n2 * 307 >> 8;
                --n;
            }
        }
        if (n2 < this.minFontSize) {
            n2 = this.minFontSize;
        }
        return n2;
    }
}

