/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLInputElement;

public class DInputElement
extends FormTypeElement
implements HTMLInputElement {
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PASSWORD = 1;
    private static final int TYPE_CHECKBOX = 2;
    private static final int TYPE_RADIO = 3;
    private static final int TYPE_SUBMIT = 4;
    private static final int TYPE_RESET = 5;
    private static final int TYPE_FILE = 6;
    private static final int TYPE_HIDDEN = 7;
    private static final int TYPE_IMAGE = 8;
    private static final int TYPE_BUTTON = 9;
    private final String[] types = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"};
    public static final int DEFAULT_MAX_LENGTH = 10000;
    public static final int DEFAULT_SIZE = 20;
    private int type = 9;
    private int in_click_x;
    private int in_click_y;
    private boolean checked = false;
    private boolean defaultChecked = false;
    private String defaultValue;
    private static final int Field_accept = 1;
    private static final int Field_accessKey = 2;
    private static final int Field_align = 3;
    private static final int Field_alt = 4;
    private static final int Field_checked = 5;
    private static final int Field_defaultValue = 6;
    private static final int Field_defaultChecked = 7;
    private static final int Field_disabled = 8;
    private static final int Field_form = 9;
    private static final int Field_maxLength = 10;
    private static final int Field_readOnly = 11;
    private static final int Field_size = 12;
    private static final int Field_src = 13;
    private static final int Field_tabIndex = 14;
    private static final int Field_type = 15;
    private static final int Field_useMap = 16;
    private static final int Field_value = 17;
    private static final int Method_blur = -1;
    private static final int Method_focus = -2;
    private static final int Method_select = -3;
    private static final int Method_click = -4;
    private static final int Method_submit = -5;

    protected DInputElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    void setAttributes(int[] nArray, String[] stringArray, int n) {
        super.setAttributes(nArray, stringArray, n);
        String string = this.getAttribute(19);
        if (string != null) {
            this.setAttribute(19, string.toUpperCase());
            this.checked = true;
        }
        this.defaultChecked = this.checked;
        this.setDefaultValue(this.getValue());
        this.updateType();
    }

    protected void onDAttrValueChange(DAttr dAttr) {
        if (dAttr.nameId == 111) {
            this.updateType();
        }
        super.onDAttrValueChange(dAttr);
    }

    void updateType() {
        int n = 0;
        String string = this.getAttribute(111);
        if (string != null) {
            int n2 = 0;
            while (n2 != this.types.length) {
                if (string.equalsIgnoreCase(this.types[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        this.type = n;
        this.setDAttr(111, this.types[this.type], false);
        if (this.type != 8) {
            this.removeDAttr(119, true);
            this.removeDAttr(45, true);
        }
    }

    public void dispatchChange() {
        if (this.doc == null) {
            return;
        }
        DOMEvent dOMEvent = this.doc.createDOMEvent(18);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    void mouseClick(int n, int n2) {
        if (!this.getDisabled()) {
            this.in_click_x = n;
            this.in_click_y = n2;
            DFormElement dFormElement = this.getDForm();
            if (dFormElement != null) {
                if (this.type == 4 || this.type == 8) {
                    dFormElement.submitWithEvent(this);
                } else if (this.type == 5) {
                    dFormElement.reset();
                } else if (this.type == 3) {
                    this.setChecked(true);
                } else if (this.type == 2) {
                    this.setChecked(!this.getChecked());
                }
            }
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    public void setDefaultChecked(boolean bl) {
        this.defaultChecked = bl;
    }

    public String getAccept() {
        return null;
    }

    public void setAccept(String string) {
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String string) {
        this.setAttribute(4, string);
    }

    public String getAlt() {
        return this.getAttribute(8);
    }

    public void setAlt(String string) {
        this.setAttribute(8, string);
    }

    public boolean getChecked() {
        return this.checked;
    }

    public void setChecked(boolean bl) {
        if (bl == this.checked) {
            return;
        }
        if (this.type == 2) {
            this.checked = bl;
        } else if (this.type == 3) {
            if (bl) {
                String string = this.getNameOrId();
                DFormElement dFormElement = this.getDForm();
                if (dFormElement != null && string != null) {
                    HTMLCollection hTMLCollection = dFormElement.getElements();
                    int n = 0;
                    Node node = hTMLCollection.item(n++);
                    while (node != null) {
                        String string2;
                        DInputElement dInputElement;
                        if (node instanceof DInputElement && node != this && (dInputElement = (DInputElement)node).getType().equalsIgnoreCase("radio") && (string2 = dInputElement.getNameOrId()) != null && string2.equals(string)) {
                            dInputElement.setChecked(false);
                        }
                        node = hTMLCollection.item(n++);
                    }
                }
            }
            this.checked = bl;
        }
        this.setAttribute(19, bl ? "checked" : null);
        if (this.type == 2 || this.type == 3 && bl) {
            this.dispatchChange();
        }
    }

    public boolean getDisabled() {
        return this.getAttribute(38) != null;
    }

    public void setDisabled(boolean bl) {
        this.setAttribute(38, bl ? "disabled" : null);
    }

    public int getMaxLength() {
        int n = 10000;
        String string = this.getAttribute(59);
        if (string != null) {
            n = CSSUtil.parseInt(string, n);
        }
        return n;
    }

    public void setMaxLength(int n) {
        this.setAttribute(59, Integer.toString(n));
    }

    public boolean getReadOnly() {
        return this.getAttribute(89) != null;
    }

    public void setReadOnly(boolean bl) {
        this.setAttribute(89, bl ? "readonly" : null);
    }

    public String getSize() {
        return this.getAttribute(100);
    }

    public void setSize(String string) {
        this.setAttribute(100, string);
    }

    public String getSrc() {
        return this.getAttribute(102);
    }

    public void setSrc(String string) {
        this.setAttribute(102, string);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int n) {
    }

    public String getType() {
        return this.types[this.type];
    }

    public void setType(String string) {
    }

    public String getUseMap() {
        return null;
    }

    public void setUseMap(String string) {
    }

    public String getValue() {
        String string = this.getAttribute(114);
        if (string == null && (this.type == 0 || this.type == 1 || this.type == 7)) {
            string = "";
        }
        return string;
    }

    public void setValue(String string) {
        this.setAttribute(114, string);
    }

    public void dispatchSelection(int n, int n2) {
        if (this.type != 0) {
            Debug.bug();
        }
        DOMEvent dOMEvent = this.doc.createDOMEvent(17);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    public void select() {
        this.doc.getDomView().processSelectCall(this);
    }

    public void click() {
        if (this.getDisabled()) {
            return;
        }
        this.doc.getDomView().processClickCall(this);
    }

    public String getAlign() {
        return null;
    }

    public void setAlign(String string) {
    }

    void recordData(FormSubmitData formSubmitData, Object object) {
        if (this.type == 6) {
            formSubmitData.appendFileData(this.getNameOrId(), this.getValue());
        } else if (this.type == 4) {
            if (object == this) {
                formSubmitData.appendData(this.getNameOrId(), this.getValue());
            }
        } else if (this.type == 8) {
            if (object == this) {
                String string = this.getNameOrId();
                string = string == null || string.length() == 0 ? "" : string + '.';
                formSubmitData.appendData(string + "x", "" + this.in_click_x);
                formSubmitData.appendData(string + "y", "" + this.in_click_y);
            }
        } else if (this.type == 2 || this.type == 3) {
            if (this.checked) {
                String string = this.getValue();
                if (string == null) {
                    string = "on";
                }
                formSubmitData.appendData(this.getNameOrId(), string);
            }
        } else if (this.type != 9 && this.type != 5) {
            formSubmitData.appendData(this.getNameOrId(), this.getValue());
        }
    }

    void reset() {
        if (this.type == 2 || this.type == 3) {
            this.setChecked(this.getDefaultChecked());
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DInputElement.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DInputElement.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DInputElement.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getAccept();
            }
            case 2: {
                return this.getAccessKey();
            }
            case 3: {
                return this.getAlign();
            }
            case 4: {
                return this.getAlt();
            }
            case 5: {
                return dynEnv.wrapBoolean(this.getChecked());
            }
            case 6: {
                return this.getDefaultValue();
            }
            case 7: {
                return dynEnv.wrapBoolean(this.getDefaultChecked());
            }
            case 8: {
                return dynEnv.wrapBoolean(this.getDisabled());
            }
            case 9: {
                return this.getDForm();
            }
            case 10: {
                return dynEnv.wrapInt(this.getMaxLength());
            }
            case 11: {
                return dynEnv.wrapBoolean(this.getReadOnly());
            }
            case 12: {
                return this.getSize();
            }
            case 13: {
                return this.getSrc();
            }
            case 14: {
                return dynEnv.wrapInt(this.getTabIndex());
            }
            case 15: {
                return this.getType();
            }
            case 16: {
                return this.getUseMap();
            }
            case 17: {
                return this.getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setAccept(dynEnv.toStr(object));
                return 1;
            }
            case 2: {
                this.setAccessKey(dynEnv.toStr(object));
                return 1;
            }
            case 3: {
                this.setAlign(dynEnv.toStr(object));
                return 1;
            }
            case 4: {
                this.setAlt(dynEnv.toStr(object));
                return 1;
            }
            case 5: {
                this.setChecked(dynEnv.toBoolean(object));
                return 1;
            }
            case 6: {
                this.setDefaultValue(dynEnv.toStr(object));
                return 1;
            }
            case 7: {
                this.setDefaultChecked(dynEnv.toBoolean(object));
                return 1;
            }
            case 8: {
                this.setDisabled(dynEnv.toBoolean(object));
                return 1;
            }
            case 9: {
                break;
            }
            case 10: {
                this.setMaxLength(dynEnv.toInt(object));
                return 1;
            }
            case 11: {
                this.setReadOnly(dynEnv.toBoolean(object));
                return 1;
            }
            case 12: {
                this.setSize(dynEnv.toStr(object));
                return 1;
            }
            case 13: {
                this.setSrc(dynEnv.toStr(object));
                return 1;
            }
            case 14: {
                this.setTabIndex(dynEnv.toInt(object));
                return 1;
            }
            case 15: {
                this.setType(dynEnv.toStr(object));
                return 1;
            }
            case 16: {
                this.setUseMap(dynEnv.toStr(object));
                return 1;
            }
            case 17: {
                this.setValue(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.blur();
                break;
            }
            case -2: {
                this.focus();
                break;
            }
            case -3: {
                this.select();
                break;
            }
            case -4: {
                this.click();
                break;
            }
            case -5: {
                DFormElement dFormElement = this.getDForm();
                if (dFormElement == null) break;
                dFormElement.submit();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "alt";
                    n = 4;
                    break;
                }
                if (c != 's') break;
                string2 = "src";
                n = 13;
                break;
            }
            case 4: {
                switch (string.charAt(0)) {
                    case 'b': {
                        string2 = "blur";
                        n = -1;
                        break block0;
                    }
                    case 'f': {
                        string2 = "form";
                        n = 9;
                        break block0;
                    }
                    case 's': {
                        string2 = "size";
                        n = 12;
                        break block0;
                    }
                    case 't': {
                        string2 = "type";
                        n = 15;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "align";
                        n = 3;
                        break block0;
                    }
                    case 'c': {
                        string2 = "click";
                        n = -4;
                        break block0;
                    }
                    case 'f': {
                        string2 = "focus";
                        n = -2;
                        break block0;
                    }
                    case 'v': {
                        string2 = "value";
                        n = 17;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = string.charAt(1);
                if (c == 'c') {
                    string2 = "accept";
                    n = 1;
                    break;
                }
                if (c == 'e') {
                    string2 = "select";
                    n = -3;
                    break;
                }
                if (c == 's') {
                    string2 = "useMap";
                    n = 16;
                    break;
                }
                if (c != 'u') break;
                string2 = "submit";
                n = -5;
                break;
            }
            case 7: {
                string2 = "checked";
                n = 5;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "disabled";
                    n = 8;
                    break;
                }
                if (c == 'r') {
                    string2 = "readOnly";
                    n = 11;
                    break;
                }
                if (c != 't') break;
                string2 = "tabIndex";
                n = 14;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "accessKey";
                    n = 2;
                    break;
                }
                if (c != 'm') break;
                string2 = "maxLength";
                n = 10;
                break;
            }
            case 12: {
                string2 = "defaultValue";
                n = 6;
                break;
            }
            case 14: {
                string2 = "defaultChecked";
                n = 7;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

