/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFlatList;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;

final class DFormList
extends DynamicList
implements NodeList,
HTMLCollection,
Nbrs {
    private DFormElement master;
    private Vector v;
    private HashArray named;
    private int mutation = 0;

    protected DFormList(DFormElement dFormElement) {
        this.master = dFormElement;
    }

    void record() {
        Vector vector = new Vector(10);
        HashArray hashArray = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.master.recordHackedControls(hashArray, vector);
        this.record_r(this.master, hashArray, vector);
        hashArray.sealObject();
        this.named = hashArray;
        this.v = vector;
        this.mutation = this.master.doc.getMutation();
    }

    private void record_r(DNode dNode, HashArray hashArray, Vector vector) {
        this.recordFormControl(dNode, hashArray, vector);
        dNode = dNode.first;
        while (dNode != null) {
            this.record_r(dNode, hashArray, vector);
            dNode = dNode.next;
        }
    }

    void recordFormControl(DNode dNode, HashArray hashArray, Vector vector) {
        FormTypeElement formTypeElement;
        if (dNode instanceof FormTypeElement && ((formTypeElement = (FormTypeElement)dNode).isFormControl() || formTypeElement.tagId == 15) && formTypeElement.getDForm() == this.master && !vector.contains(formTypeElement)) {
            vector.addElement(formTypeElement);
            this.recordControlName(formTypeElement, hashArray);
        }
    }

    private void recordControlName(FormTypeElement formTypeElement, HashArray hashArray) {
        String string = formTypeElement.getNameOrId();
        if (string != null && string.length() > 0) {
            HashArray.Entry entry = hashArray.ensureEntry(string);
            Object object = entry.value;
            if (object == null) {
                entry.value = formTypeElement;
            } else {
                DFlatList dFlatList;
                if (object instanceof DElement) {
                    dFlatList = new DFlatList();
                    dFlatList.append((DElement)object);
                    entry.value = dFlatList;
                } else {
                    dFlatList = (DFlatList)object;
                }
                dFlatList.append(formTypeElement);
            }
        }
    }

    public Node item(int n) {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        if (n < 0 || this.v.size() <= n) {
            return null;
        }
        return (Node)this.v.elementAt(n);
    }

    protected Object script_item(int n, DynEnv dynEnv) {
        return this.item(n);
    }

    public int getLength() {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.v.size();
    }

    public Node namedItem(String string) {
        Object object;
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        if ((object = this.named.get(string)) instanceof DFlatList) {
            object = ((DFlatList)object).item(0);
        }
        return (Node)object;
    }

    protected Object script_namedItem(String string, DynEnv dynEnv) {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.named.get(string);
    }
}

