/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAllList;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DFragment;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DIsIndexElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DRange;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DStyleSheetList;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DXmlElement;
import ice.pilots.html4.DomEventItem;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.Names;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TheView;
import ice.pilots.html4.Transformer;
import ice.pilots.html4.TransformerFactory;
import ice.storm.ContentLoader;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.StormLocaleUtils;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.alg.Bidi;
import ice.util.alg.HashArray;
import ice.util.net.CookieSet;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class DDocument
extends DNode
implements Document,
HTMLDocument,
DocumentStyle,
DocumentEvent,
DocumentView {
    public static boolean STRICT = false;
    private String _baseUrl;
    private URL _serverRoot = null;
    private String baseTarget = "_self";
    int defaultNamespace = 3;
    ThePilot pilot;
    boolean isFrameset = false;
    private DElement rootElement;
    private int mutation = 0;
    private DAllList all;
    private DNodeList images;
    private DNodeList forms;
    private DNodeList links;
    private DNodeList maps;
    private DNodeList iframes;
    private DRange selection;
    private String defaultCharset;
    private BreakIterator wordIterator;
    private DStyleSheetList styleSheetList;
    private String linkColor;
    private String vlinkColor;
    private String alinkColor;
    private HashArray httpProperties;
    Names names;
    private boolean async = false;
    private String lang;
    private DOM _domImplementation;
    private DDocument _parentDocument;
    CookieSet cookieSet;
    private static final String sysLanguage = Defs.sysProperty("user.language");
    private final DMutationEvent aMutationEvent = new DMutationEvent(this, 25);
    int charsetId = 0;
    private static final int Field_async = 1;
    private static final int Field_alinkColor = 2;
    private static final int Field_all = 3;
    private static final int Field_anchors = 4;
    private static final int Field_applets = 5;
    private static final int Field_bgColor = 6;
    private static final int Field_body = 7;
    private static final int Field_cookie = 8;
    private static final int Field_defaultCharset = 9;
    private static final int Field_defaultView = 10;
    private static final int Field_doctype = 11;
    private static final int Field_documentElement = 12;
    private static final int Field_domain = 13;
    private static final int Field_errorCode = 14;
    private static final int Field_fgColor = 15;
    private static final int Field_forms = 16;
    private static final int Field_frames = 17;
    private static final int Field_head = 18;
    private static final int Field_height = 19;
    private static final int Field_images = 20;
    private static final int Field_implementation = 21;
    private static final int Field_lastModified = 22;
    private static final int Field_linkColor = 23;
    private static final int Field_links = 24;
    private static final int Field_location = 25;
    private static final int Field_maps = 26;
    private static final int Field_nodeName = 27;
    private static final int Field_nodeType = 28;
    private static final int Field_parseError = 29;
    private static final int Field_reason = 30;
    private static final int Field_referrer = 31;
    private static final int Field_selection = 32;
    private static final int Field_SRC = 33;
    private static final int Field_styleSheets = 34;
    private static final int Field_title = 35;
    private static final int Field_URL = 36;
    private static final int Field_vlinkColor = 37;
    private static final int Field_width = 38;
    private static final int Method_addStyleSheet = -1;
    private static final int Method_clear = -2;
    private static final int Method_close = -3;
    private static final int Method_createAttribute = -4;
    private static final int Method_createAttributeNS = -5;
    private static final int Method_createCDATASection = -6;
    private static final int Method_createComment = -7;
    private static final int Method_createDocumentFragment = -8;
    private static final int Method_createElement = -9;
    private static final int Method_createElementNS = -10;
    private static final int Method_createElementWithNameSpace = -11;
    private static final int Method_createEntityReference = -12;
    private static final int Method_createEvent = -13;
    private static final int Method_createProcessingInstruction = -14;
    private static final int Method_createTextNode = -15;
    private static final int Method_getElementById = -16;
    private static final int Method_getElementsByName = -17;
    private static final int Method_getElementsByTagName = -18;
    private static final int Method_getElementsByTagNameNS = -19;
    private static final int Method_importNode = -20;
    private static final int Method_load = -21;
    private static final int Method_loadXML = -22;
    private static final int Method_open = -23;
    private static final int Method_removeStyleSheet = -24;
    private static final int Method_resolveURL = -25;
    private static final int Method_transformNode = -26;
    private static final int Method_transformNodeToObject = -27;
    private static final int Method_write = -28;
    private static final int Method_writeln = -29;
    private static final int Method_getBGColor = -30;
    private static final int Method_setBGColor = -31;

    public final void mutate() {
        ++this.mutation;
    }

    public final int getMutation() {
        return this.mutation;
    }

    protected DDocument(ThePilot thePilot, DOM dOM) {
        super(null, 0);
        this.pilot = thePilot;
        this._domImplementation = dOM.createDocumentSlave(this);
        this._parentDocument = dOM.getMasterDocument();
        this.names = this._domImplementation.sdata.names;
        this.doc = this;
        this.styleSheetList = new DStyleSheetList();
        this.lang = sysLanguage;
    }

    Names getNames() {
        return this.names;
    }

    public boolean isRTL() {
        CSSBox cSSBox;
        CSSLayout cSSLayout;
        DElement dElement = this.getDBody();
        return dElement != null && (cSSLayout = this.pilot.getCSSLayout()) != null && (cSSBox = cSSLayout.findCSSBox(dElement)) != null && cSSBox.css.directionFlag == 1;
    }

    public void setHtmlMode(boolean bl) {
        this.defaultNamespace = bl ? 3 : 0;
    }

    protected void clear() {
        this.unlinkAllSlots();
        this.removeAllDAttrs();
        this._baseUrl = null;
        this._serverRoot = null;
        this.baseTarget = "_self";
        this.httpProperties = null;
        DElement dElement = this.rootElement;
        if (dElement != null) {
            this.removeDChild(dElement);
            dElement.dispose();
        }
        this.isFrameset = false;
        this.styleSheetList.clear();
        this.selection.empty();
        this.linkColor = null;
        this.mutation = 0;
        this.all = null;
        this.images = null;
        this.forms = null;
        this.iframes = null;
        this.links = null;
        this.maps = null;
    }

    public final ThePilot getPilot() {
        return this.pilot;
    }

    public final Viewport getDocumentVieport() {
        ThePilot thePilot = this.getPilot();
        if (thePilot != null) {
            return thePilot.getPilotViewport();
        }
        return null;
    }

    DRange createRange() {
        return new DRange(this);
    }

    public Event createEvent(String string) {
        int n = DOMEvent.mapEventTypeToId(string);
        if (n <= 0) {
            throw new DOMException(9, string);
        }
        return this.createDOMEvent(n);
    }

    public DOMEvent createDOMEvent(int n) {
        switch (n) {
            case 29: {
                return new DMutationEvent(this, n);
            }
            case 28: {
                this.aMutationEvent.typeId = 28;
                return this.aMutationEvent;
            }
            case 26: {
                this.aMutationEvent.typeId = 26;
                return this.aMutationEvent;
            }
            case 27: {
                this.aMutationEvent.typeId = 27;
                return this.aMutationEvent;
            }
            case 25: {
                this.aMutationEvent.typeId = 25;
                return this.aMutationEvent;
            }
        }
        return new DOMUIEvent(this, n);
    }

    public final DOMEvent createDOMEvent(int n, DNode dNode) {
        DOMEvent dOMEvent = this.createDOMEvent(n);
        dOMEvent.setTarget(dNode);
        return dOMEvent;
    }

    public void processEvent(int n, DNode dNode) {
        DOMEvent dOMEvent = this.createDOMEvent(n, dNode);
        this.processEvent(dOMEvent);
    }

    void processEventLater(DOMEvent dOMEvent, long l) {
        new DomEventItem(this.doc, dOMEvent).postToEventThread(l);
    }

    void processEvent(DOMEvent dOMEvent) {
        Object object;
        ThePilot thePilot = this.getPilot();
        Object[] objectArray = null;
        if (thePilot != null) {
            objectArray = thePilot.persistentDomListeners;
        }
        dOMEvent.setEventPhase((short)1);
        DNodeListeners.handleEvent(objectArray, dOMEvent, true);
        DNode dNode = dOMEvent.target;
        if (dNode != null) {
            this.do_event_capture_r(dNode.parent, dOMEvent);
        }
        dOMEvent.setEventPhase((short)3);
        boolean bl = dOMEvent.getBubbles();
        int n = DDocument.getEventHandlerAttr(dOMEvent);
        while (dNode != null && !dOMEvent.cancel) {
            DAttr dAttr;
            dOMEvent.currentNode = dNode;
            object = dNode.eventListeners;
            if (object != null) {
                DNodeListeners.handleEvent((Object[])object, dOMEvent, false);
            }
            if (n > 0 && (dAttr = dNode.getDAttr(n)) != null && thePilot != null) {
                Object object2 = dAttr.getObjectValue();
                thePilot.evalScriptHandlerListeners(dNode, dOMEvent, object2);
            }
            if (!bl) break;
            dNode = DDocument.getEventChainParent(dNode, dOMEvent);
        }
        if (!dOMEvent.getCancelable() || !dOMEvent.cancel) {
            DNodeListeners.handleEvent(objectArray, dOMEvent, false);
        }
        if (!dOMEvent.isDefaultCancelled() && thePilot != null && (object = thePilot.defaultEventHandler) != null) {
            object.handleEvent(dOMEvent);
        }
    }

    private void do_event_capture_r(DNode dNode, DOMEvent dOMEvent) {
        if (dNode != null) {
            Object[] objectArray = dNode.eventListeners;
            while (objectArray == null) {
                if ((dNode = DDocument.getEventChainParent(dNode, dOMEvent)) == null) {
                    return;
                }
                objectArray = dNode.eventListeners;
            }
            this.do_event_capture_r(DDocument.getEventChainParent(dNode, dOMEvent), dOMEvent);
            if (!dOMEvent.getCancelable() || !dOMEvent.cancel) {
                dOMEvent.currentNode = dNode;
                DNodeListeners.handleEvent(objectArray, dOMEvent, true);
            }
        }
    }

    static DNode getEventChainParent(DNode dNode, DOMEvent dOMEvent) {
        if (dNode.tagId == 55 && dOMEvent.nodeAfterMap != null) {
            return dOMEvent.nodeAfterMap;
        }
        return dNode.parent;
    }

    private static int getEventHandlerAttr(DOMEvent dOMEvent) {
        int n;
        switch (dOMEvent.getTypeId()) {
            case 22: {
                n = 69;
                break;
            }
            case 18: {
                n = 70;
                break;
            }
            case 1: {
                n = 71;
                break;
            }
            case 2: {
                n = 72;
                break;
            }
            case 21: {
                n = 73;
                break;
            }
            case 9: {
                n = 74;
                break;
            }
            case 8: {
                n = 75;
                break;
            }
            case 10: {
                n = 76;
                break;
            }
            case 13: {
                n = 77;
                break;
            }
            case 3: {
                n = 78;
                break;
            }
            case 6: {
                n = 79;
                break;
            }
            case 7: {
                n = 80;
                break;
            }
            case 5: {
                n = 81;
                break;
            }
            case 4: {
                n = 82;
                break;
            }
            case 20: {
                n = 83;
                break;
            }
            case 17: {
                n = 84;
                break;
            }
            case 19: {
                n = 85;
                break;
            }
            case 14: {
                n = 86;
                break;
            }
            case 23: {
                n = 121;
                break;
            }
            case 24: {
                n = 122;
                break;
            }
            default: {
                return -1;
            }
        }
        if (!DDocument.isEventHandlerAttr(n)) {
            Debug.bug();
        }
        return n;
    }

    static boolean isEventHandlerAttr(int n) {
        switch (n) {
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 121: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    protected DElement createElement(int n) {
        switch (n) {
            case 94: {
                return new DXmlElement(this, n);
            }
            case 49: {
                return new DIsIndexElement(this, n);
            }
            case 46: {
                return new DImageElement(this, n);
            }
            case 45: {
                return new DIFrameElement(this, n);
            }
            case 1: {
                return new DAnchorElement(this, n);
            }
            case 32: {
                return new DFormElement(this, n);
            }
            case 15: 
            case 47: {
                return new DInputElement(this, n);
            }
            case 82: {
                return new DTextAreaElement(this, n);
            }
            case 71: {
                return new DSelectElement(this, n);
            }
            case 63: {
                return new DOptionElement(this, n);
            }
            case 55: {
                return new DMapElement(this, n);
            }
            case 6: {
                return new DAreaElement(this, n);
            }
            case 5: {
                return new DAppletElement(this, n);
            }
        }
        return new DElement(this, n);
    }

    protected DTextNode createDTextNode(char[] cArray, int n, int n2, boolean bl) {
        return new DTextNode(this, cArray, n, n2, bl);
    }

    protected DTextNode createDTextNode(String string, boolean bl) {
        return new DTextNode(this, string, bl);
    }

    protected final DTextNode createDTextNode(String string) {
        return this.createDTextNode(string, false);
    }

    protected DAttr createAttribute(int n) {
        return new DAttr(n);
    }

    protected DNode appendDChild(DNode dNode) {
        if (this.rootElement != null) {
            if (Debug.trace) {
                Debug.trace("WARNING: Document already has root element " + this.rootElement);
            }
            return null;
        }
        if (!(dNode instanceof DElement)) {
            if (Debug.trace) {
                Debug.trace("WARNING: Document cannot have root that is not an Element");
            }
            return null;
        }
        this.rootElement = (DElement)dNode;
        this.first = this.last = dNode;
        dNode.setParent(this);
        this.mutate();
        DMutationEvent dMutationEvent = (DMutationEvent)this.createDOMEvent(26);
        dMutationEvent.target = dNode;
        dMutationEvent.relatedNode = this;
        this.processEvent(dMutationEvent);
        return dNode;
    }

    protected DNode removeDChild(DNode dNode) {
        if (dNode != null && this.rootElement == dNode) {
            DMutationEvent dMutationEvent = (DMutationEvent)this.createDOMEvent(27);
            dMutationEvent.target = dNode;
            dMutationEvent.relatedNode = this;
            this.processEvent(dMutationEvent);
            this.rootElement.setParent(null);
            this.rootElement = null;
            this.last = null;
            this.first = null;
            this.mutate();
            return dNode;
        }
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        return this.getDom();
    }

    public DOM getDom() {
        return this._domImplementation;
    }

    public final Element getDocumentElement() {
        return this.getDocumentDElement();
    }

    public DElement getDocumentDElement() {
        return this.rootElement;
    }

    public Element createElement(String string) {
        int n = this.names.getTagId(this.defaultNamespace, string);
        if (n < 0) {
            return null;
        }
        return this.createElement(n);
    }

    public DocumentFragment createDocumentFragment() {
        return new DFragment(this);
    }

    public final Text createTextNode(String string) {
        return this.createDTextNode(string);
    }

    public Comment createComment(String string) {
        return null;
    }

    public CDATASection createCDATASection(String string) {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return null;
    }

    public Attr createAttribute(String string) {
        int n = this.names.getAttrId(this.defaultNamespace, string);
        if (n < 0) {
            return null;
        }
        return this.createAttribute(n);
    }

    public EntityReference createEntityReference(String string) {
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        return new DNodeList(this, string);
    }

    public String getTitle() {
        DNode dNode = this.getHead();
        if (dNode == null) {
            return "";
        }
        dNode = dNode.getFirstDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 86) {
                dNode = dNode.getFirstDChild();
                String string = "";
                while (dNode != null) {
                    string = string.length() == 0 ? dNode.getNodeValue() : string + dNode.getNodeValue();
                    dNode = dNode.next;
                }
                return string;
            }
            dNode = dNode.next;
        }
        return "";
    }

    public void setTitle(String string) {
    }

    public String getReferrer() {
        String string = this.getHttpProperty("_http_referer");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public URL getBaseURL() {
        String string = this.pilot.getPilotViewport().getBaseUrl();
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDomain() {
        String string = this.getBaseUrl();
        if (string != null) {
            return this.getPilot().getUrlMaster().getHost(string);
        }
        return null;
    }

    public final String getURL() {
        ThePilot thePilot = this.getPilot();
        if (thePilot != null) {
            return thePilot.getPilotViewport().getLocation();
        }
        return null;
    }

    public final HTMLElement getBody() {
        return this.getDBody();
    }

    public DElement getDBody() {
        DNode dNode = this.rootElement;
        if (dNode != null) {
            dNode = dNode.getFirstDChild();
            while (dNode != null && dNode.getNameId() != 13) {
                dNode = dNode.next;
            }
        }
        return dNode;
    }

    public void setBody(HTMLElement hTMLElement) {
    }

    public HTMLCollection getImages() {
        if (this.images == null) {
            this.images = new DNodeList(this, "img");
        }
        return this.images;
    }

    public HTMLCollection getApplets() {
        return new DNodeList(this, "applet");
    }

    public HTMLCollection getLinks() {
        if (this.links == null) {
            this.links = new DNodeList(this, "_links_", "href");
        }
        return this.links;
    }

    public HTMLCollection getForms() {
        if (this.forms == null) {
            this.forms = new DNodeList(this, "form");
        }
        return this.forms;
    }

    HTMLCollection getIFrames() {
        if (this.iframes == null) {
            this.iframes = new DNodeList(this, "iframe");
        }
        return this.iframes;
    }

    public HTMLCollection getAnchors() {
        return new DNodeList(this, "a", "name");
    }

    public HTMLCollection getMaps() {
        if (this.maps == null) {
            this.maps = new DNodeList(this, "map");
        }
        return this.maps;
    }

    public String getCookie() {
        String string = "";
        if (this.cookieSet != null && (string = this.cookieSet.getCookieStr(this.getBaseUrl())) == null) {
            string = "";
        }
        return string;
    }

    public void setCookie(String string) {
        if (this.cookieSet != null) {
            this.cookieSet.addCookie(this.getBaseUrl(), string);
        }
    }

    public String getLastModified() {
        String string = this.getHttpProperty("_http_last-modified");
        if (string == null) {
            return "0";
        }
        return string;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    void setUnresolvedCharset(String string) {
        if (string != null) {
            this.charsetId = Bidi.getCharsetId(string);
        }
    }

    void setDefaultCharset(String string) {
        this.defaultCharset = string;
    }

    public void open() {
    }

    public void close() {
        this.pilot.do_document_close();
    }

    public void write(final String string) {
        SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                DDocument.this.pilot.do_document_write(string);
                return null;
            }
        });
    }

    public void writeln(String string) {
        this.write(string + '\n');
    }

    public Element getElementById(String string) {
        if (this.rootElement == null) {
            return null;
        }
        return this.getAll().getElementById(string);
    }

    public NodeList getElementsByName(String string) {
        return this.getAll().getElementsByName(string);
    }

    public StyleSheetList getStyleSheets() {
        return this.styleSheetList;
    }

    public final AbstractView getDefaultView() {
        return this.getDomView();
    }

    public TheView getDomView() {
        return this.pilot.getView();
    }

    public Element createElementWithNameSpace(String string, String string2) {
        int n = this.names.getNamespace(string2);
        int n2 = this.names.getTagId(n, string);
        if (n2 < 0) {
            return null;
        }
        return this.createElement(n2);
    }

    public int getWidth() {
        int n;
        TheView theView = this.getDomView();
        if (theView == null) {
            return 0;
        }
        int n2 = theView.getWidth();
        if (n2 < (n = theView.getDocPane().getPaneWidth())) {
            n2 = n;
        }
        return n2;
    }

    public int getHeight() {
        int n;
        TheView theView = this.getDomView();
        if (theView == null) {
            return 0;
        }
        int n2 = theView.getHeight();
        if (n2 < (n = theView.getDocPane().getPaneHeight())) {
            n2 = n;
        }
        return n2;
    }

    public DAllList getAll() {
        if (this.all == null) {
            this.all = new DAllList(this, true);
        }
        return this.all;
    }

    public DRange getSelection() {
        if (this.selection == null) {
            this.selection = this.createRange();
        }
        return this.selection;
    }

    public boolean getAsync() {
        return this.async;
    }

    public void setAsync(boolean bl) {
        this.async = bl;
    }

    protected void script_load(DynEnv dynEnv, String string) throws IOException {
        if (string != null) {
            final String string2 = this.resolveUrl(string);
            Reader reader = (Reader)SecurityKit.doPrivileged(new BoxedCode(){

                public Object run() {
                    try {
                        return DDocument.this.openUrlReader(string2);
                    }
                    catch (IOException iOException) {
                        throw new ProxyException(iOException);
                    }
                }
            });
            try {
                DElement dElement = (DElement)this.doc.getDocumentElement();
                this.removeChild(dElement);
                DOMBuilder dOMBuilder = new DOMBuilder(this, null);
                Lex2 lex2 = new Lex2(dOMBuilder);
                lex2.setReader(reader);
                lex2.parse();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            {
            }
        }
    }

    protected void script_loadXML(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        DElement dElement = (DElement)this.doc.getDocumentElement();
        this.removeChild(dElement);
        DOMBuilder dOMBuilder = new DOMBuilder(this, null);
        Lex2 lex2 = new Lex2(dOMBuilder);
        lex2.setReader(stringReader);
        lex2.parse();
    }

    protected String transformNode(Document document) throws IOException {
        TransformerFactory transformerFactory = this.getDom().getTransformFactory();
        StringBuffer stringBuffer = null;
        if (transformerFactory != null) {
            Transformer transformer = transformerFactory.createTransformer();
            DElement dElement = (DElement)this.doc.getDocumentElement();
            DNode dNode = (DNode)((Object)this.doc.createDocumentFragment());
            dNode.appendChild(dElement);
            StringWriter stringWriter = new StringWriter();
            transformer.transform((Node)dNode, (Node)document, stringWriter);
            stringBuffer = stringWriter.getBuffer();
            return stringBuffer.toString();
        }
        return null;
    }

    protected void transformNodeToObject(Document document, Document document2) throws IOException {
        TransformerFactory transformerFactory = this.getDom().getTransformFactory();
        if (transformerFactory != null) {
            Transformer transformer = transformerFactory.createTransformer();
            document2.removeChild(document2.getDocumentElement());
            DElement dElement = (DElement)this.doc.getDocumentElement();
            DNode dNode = (DNode)((Object)this.doc.createDocumentFragment());
            dNode.appendChild(dElement);
            ((DDocument)document2).defaultNamespace = 3;
            transformer.transform((Node)dNode, (Node)document, document2);
            if (((DDocument)document2).pilot != null) {
                ((DDocument)document2).pilot.refresh();
            }
        }
    }

    String getCurrentLocation() {
        if (this.pilot != null) {
            return this.pilot.getPilotViewport().getLocation();
        }
        return null;
    }

    void setHttpProperty(String string, String string2) {
        if (this.httpProperties == null) {
            this.httpProperties = new HashArray();
        }
        this.httpProperties.put(string, (Object)string2);
    }

    String getHttpProperty(String string) {
        HashArray hashArray = this.httpProperties;
        if (hashArray != null) {
            return (String)hashArray.get(string);
        }
        return null;
    }

    public Object getSlot(String string, DynEnv dynEnv) {
        Object object = super.getSlot(string, dynEnv);
        if (object == DynamicObject.NOT_FOUND && this.rootElement != null) {
            object = this.getAll().getSlot(string, dynEnv);
        }
        return object;
    }

    public void addStyleSheet(DStyleSheet dStyleSheet) {
        this.styleSheetList.addStyleSheet(dStyleSheet);
        this.mutate();
        this.processEvent(25, this);
    }

    public void removeStyleSheet(DStyleSheet dStyleSheet) {
        this.styleSheetList.removeStyleSheet(dStyleSheet);
        this.mutate();
        this.processEvent(25, this);
    }

    public URL resolveURL(String string) {
        string = this.resolveUrl(string);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    Reader openUrlReader(String string) throws IOException {
        ContentLoader contentLoader = this.pilot.getUrlMaster().createLoader(string);
        InputStream inputStream = contentLoader.getInputStream();
        if (inputStream == null) {
            IOException iOException = contentLoader.getException();
            throw iOException != null ? iOException : new IOException();
        }
        String string2 = contentLoader.getContentCharset();
        if (string2 == null) {
            string2 = this.getDefaultCharset();
        }
        return StormLocaleUtils.createInputStreamReader(inputStream, string2);
    }

    public String resolveUrl(String string) {
        String string2;
        String string3 = this.getBaseUrl();
        if (this._serverRoot != null && string != null && (string2 = string.trim()).startsWith("/")) {
            string3 = this._serverRoot.toExternalForm();
            string = string2.substring(1);
        }
        string2 = this.pilot.getUrlMaster().resolve(string3, string);
        return string2;
    }

    String resolveUrl(String string, String string2) {
        return this.pilot.getUrlMaster().resolve(string, string2);
    }

    String getBaseUrl() {
        DDocument dDocument = this;
        do {
            if (dDocument._baseUrl == null) continue;
            return dDocument._baseUrl;
        } while ((dDocument = dDocument._parentDocument) != null);
        ThePilot thePilot = this.getPilot();
        return thePilot.getPilotViewport().getBaseUrl();
    }

    void setBaseUrl(String string) {
        if (string == null) {
            Debug.bug();
        }
        this._baseUrl = string;
        if (this.pilot != null) {
            this.pilot.putBaseUrl(string);
        }
    }

    void setServerRoot(URL uRL) {
        this._serverRoot = uRL;
    }

    void setBaseTarget(String string) {
        this.baseTarget = string;
    }

    String getBaseTarget() {
        return this.baseTarget;
    }

    public DElement getHead() {
        if (this.rootElement == null) {
            return null;
        }
        DNode dNode = this.rootElement;
        dNode = dNode.getFirstDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 41) break;
            dNode = dNode.next;
        }
        return dNode;
    }

    void validateBodyAttrs() {
        DElement dElement = this.getDBody();
        if (dElement == null) {
            return;
        }
        this.setLinkColor(dElement.getAttribute(55));
        this.setVlinkColor(dElement.getAttribute(117));
        this.setAlinkColor(dElement.getAttribute(7));
        this.setBgColor(dElement.getAttribute(12));
        this.setFgColor(dElement.getAttribute(109));
    }

    void firePropertyChange(String string, Object object, Object object2) {
        if (this.pilot != null) {
            this.pilot.firePropertyChange(string, object, object2);
        }
    }

    void notifyLayoutBegin() {
        if (this.pilot != null) {
            this.pilot.firePropertyChange("contentRendering", null, "begin");
        }
    }

    void notifyLayoutBuilt() {
        if (this.pilot != null) {
            // empty if block
        }
    }

    void notifyLayoutEnd() {
        if (this.pilot != null) {
            this.pilot.firePropertyChange("contentRendering", null, "end");
            this.pilot.sendBodyLoadEvent();
        }
    }

    void parseHtmlSubtree(DNode dNode, String string) {
        try {
            DOMBuilder dOMBuilder = new DOMBuilder(this, dNode, this.pilot);
            dOMBuilder.noJS = true;
            Lex2 lex2 = new Lex2(dOMBuilder);
            lex2.setReader(new StringReader(string));
            lex2.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFgColor() {
        DElement dElement = (DElement)this.getBody();
        if (dElement != null) {
            return dElement.getAttribute(109);
        }
        return null;
    }

    public void setFgColor(String string) {
        if (string == null) {
            return;
        }
        string = CSSUtil.convertColorNameToRGB(string);
        DElement dElement = (DElement)this.getBody();
        if (dElement != null) {
            dElement.getStyle().setProperty(CSSLookup.getPropName(33), string, "");
            this.mutate();
        }
    }

    public String getBgColor() {
        DElement dElement = (DElement)this.getBody();
        if (dElement != null) {
            return dElement.getAttribute(12);
        }
        return null;
    }

    public void setBgColor(String string) {
        if (string == null) {
            return;
        }
        string = CSSUtil.convertColorNameToRGB(string);
        DElement dElement = (DElement)this.getBody();
        if (dElement != null) {
            dElement.getStyle().setProperty(CSSLookup.getPropName(5), string, "");
            this.mutate();
        }
    }

    public String getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(String string) {
        if (string == null) {
            return;
        }
        string = CSSUtil.convertColorNameToRGB(string);
        this.linkColor = string;
        try {
            DNodeList dNodeList = (DNodeList)this.getLinks();
            if (dNodeList != null) {
                int n = 0;
                while (n < dNodeList.getLength()) {
                    DNode dNode = (DNode)dNodeList.item(n);
                    if (dNode != null && dNode instanceof DAnchorElement) {
                        ((DAnchorElement)dNode).getStyle().setProperty(CSSLookup.getPropName(33), string, "");
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mutate();
    }

    public String getAlinkColor() {
        return this.alinkColor;
    }

    public void setAlinkColor(String string) {
        if (string != null) {
            string = CSSUtil.convertColorNameToRGB(string);
        }
        this.alinkColor = string;
        this.mutate();
    }

    public String getVlinkColor() {
        return this.vlinkColor;
    }

    public void setVlinkColor(String string) {
        if (string != null) {
            string = CSSUtil.convertColorNameToRGB(string);
        }
        this.vlinkColor = string;
        this.mutate();
    }

    public Node importNode(Node node, boolean bl) {
        return null;
    }

    public Element createElementNS(String string, String string2) {
        return null;
    }

    public Attr createAttributeNS(String string, String string2) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return null;
    }

    private DynamicObject script_getWindow() {
        Viewport viewport = this.pilot.getPilotViewport();
        return viewport != null ? viewport.getWindowObj() : null;
    }

    private Object script_open(Object[] objectArray, DynEnv dynEnv) {
        if (objectArray.length == 0) {
            this.open();
        } else {
            DynamicObject dynamicObject = this.script_getWindow();
            if (dynamicObject != null) {
                return dynamicObject.execDynamicMethod("openDocument", objectArray, dynEnv);
            }
        }
        return dynEnv.wrapVoid();
    }

    public Object getDynamicScopeParent() {
        return this.getDocumentVieport();
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DDocument.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(string, n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DDocument.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(string, n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DDocument.toDynamicId(string);
        if (n < 0) {
            try {
                return this.execDynamicMethod(n, objectArray, dynEnv);
            }
            catch (ProxyException proxyException) {
                throw dynEnv.wrapException(proxyException.getTarget());
            }
            catch (IOException iOException) {
                throw dynEnv.wrapException(iOException);
            }
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(String string, int n, DynEnv dynEnv) {
        DynamicObject dynamicObject;
        boolean bl = false;
        switch (n) {
            case 1: {
                return dynEnv.wrapBoolean(this.getAsync());
            }
            case 2: {
                return this.getAlinkColor();
            }
            case 3: {
                return this.getAll();
            }
            case 4: {
                return this.getAnchors();
            }
            case 5: {
                return this.getApplets();
            }
            case 6: {
                return this.getBgColor();
            }
            case 7: {
                return this.getBody();
            }
            case 8: {
                return this.getCookie();
            }
            case 9: {
                return this.getDefaultCharset();
            }
            case 10: {
                return this.getDefaultView();
            }
            case 11: {
                return this.getDoctype();
            }
            case 12: {
                return this.getDocumentElement();
            }
            case 13: {
                return this.getDomain();
            }
            case 14: {
                return dynEnv.wrapInt(0);
            }
            case 15: {
                return this.getFgColor();
            }
            case 16: {
                return this.getForms();
            }
            case 17: {
                bl = true;
                break;
            }
            case 18: {
                return this.getHead();
            }
            case 19: {
                return dynEnv.wrapInt(this.getHeight());
            }
            case 20: {
                return this.getImages();
            }
            case 21: {
                return this.getImplementation();
            }
            case 22: {
                return this.getLastModified();
            }
            case 23: {
                return this.getLinkColor();
            }
            case 24: {
                return this.getLinks();
            }
            case 25: {
                bl = true;
                break;
            }
            case 26: {
                return this.getMaps();
            }
            case 27: {
                return this.getNodeName();
            }
            case 28: {
                return dynEnv.wrapInt(this.getNodeType());
            }
            case 29: {
                return this;
            }
            case 30: {
                return "Parseerror reason not supported";
            }
            case 31: {
                return this.getReferrer();
            }
            case 32: {
                return this.getSelection();
            }
            case 33: {
                return "Document src listing not implemented";
            }
            case 34: {
                return this.getStyleSheets();
            }
            case 35: {
                return this.getTitle();
            }
            case 36: {
                return this.getURL();
            }
            case 37: {
                return this.getVlinkColor();
            }
            case 38: {
                return dynEnv.wrapInt(this.getWidth());
            }
        }
        if (bl && (dynamicObject = this.script_getWindow()) != null) {
            return dynamicObject.getDynamicValue(string, dynEnv);
        }
        return null;
    }

    private int setDynamicValue(String string, int n, Object object, DynEnv dynEnv) {
        DynamicObject dynamicObject;
        boolean bl = false;
        switch (n) {
            case 1: {
                this.setAsync(dynEnv.toBoolean(object));
                return 1;
            }
            case 2: {
                this.setAlinkColor(dynEnv.toStr(object));
                return 1;
            }
            case 6: {
                this.setBgColor(dynEnv.toStr(object));
                return 1;
            }
            case 7: {
                this.setBody((HTMLElement)dynEnv.toNative(object));
                return 1;
            }
            case 8: {
                this.setCookie(dynEnv.toStr(object));
                return 1;
            }
            case 14: {
                return 1;
            }
            case 15: {
                this.setFgColor(dynEnv.toStr(object));
                return 1;
            }
            case 17: {
                bl = true;
                break;
            }
            case 23: {
                this.setLinkColor(dynEnv.toStr(object));
                return 1;
            }
            case 25: {
                bl = true;
                break;
            }
            case 35: {
                this.setTitle(dynEnv.toStr(object));
                return 1;
            }
            case 37: {
                this.setVlinkColor(dynEnv.toStr(object));
                return 1;
            }
        }
        if (bl && (dynamicObject = this.script_getWindow()) != null) {
            return dynamicObject.setDynamicValue(string, object, dynEnv);
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) throws IOException {
        switch (n) {
            case -1: {
                this.addStyleSheet((DStyleSheet)dynEnv.toNative(objectArray, 0));
                break;
            }
            case -2: {
                this.open();
                break;
            }
            case -3: {
                this.close();
                break;
            }
            case -4: {
                return this.createAttribute(dynEnv.toStr(objectArray, 0));
            }
            case -5: {
                return this.createAttributeNS(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -6: {
                return this.createCDATASection(dynEnv.toStr(objectArray, 0));
            }
            case -7: {
                return this.createComment(dynEnv.toStr(objectArray, 0));
            }
            case -8: {
                return this.createDocumentFragment();
            }
            case -9: {
                return this.createElement(dynEnv.toStr(objectArray, 0));
            }
            case -10: {
                return this.createElementNS(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -11: {
                return this.createElementWithNameSpace(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -12: {
                return this.createEntityReference(dynEnv.toStr(objectArray, 0));
            }
            case -13: {
                return this.createEvent(dynEnv.toStr(objectArray, 0));
            }
            case -14: {
                return this.createProcessingInstruction(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -15: {
                return this.createTextNode(dynEnv.toStr(objectArray, 0));
            }
            case -16: {
                return this.getElementById(dynEnv.toStr(objectArray, 0));
            }
            case -17: {
                return this.getElementsByName(dynEnv.toStr(objectArray, 0));
            }
            case -18: {
                return this.getElementsByTagName(dynEnv.toStr(objectArray, 0));
            }
            case -19: {
                return this.getElementsByTagNameNS(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -20: {
                boolean bl = dynEnv.toBoolean(objectArray, 1);
                return this.importNode((Node)dynEnv.toNative(objectArray, 0), bl);
            }
            case -21: {
                this.script_load(dynEnv, dynEnv.toStr(objectArray, 0));
                break;
            }
            case -22: {
                this.script_loadXML(dynEnv.toStr(objectArray, 0));
                break;
            }
            case -23: {
                return this.script_open(objectArray, dynEnv);
            }
            case -24: {
                this.removeStyleSheet((DStyleSheet)dynEnv.toNative(objectArray, 0));
                break;
            }
            case -25: {
                return this.resolveUrl(dynEnv.toStr(objectArray, 0));
            }
            case -26: {
                return this.transformNode((Document)dynEnv.toNative(objectArray, 0));
            }
            case -27: {
                this.transformNodeToObject((Document)dynEnv.toNative(objectArray, 0), (Document)dynEnv.toNative(objectArray, 0));
                break;
            }
            case -28: {
                this.write(dynEnv.fuseArgsToString(objectArray));
                break;
            }
            case -29: {
                this.writeln(dynEnv.fuseArgsToString(objectArray));
                break;
            }
            case -30: {
                return this.getBgColor();
            }
            case -31: {
                this.setBgColor(dynEnv.toStr(objectArray, 0));
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'S') {
                    string2 = "SRC";
                    n = 33;
                    break;
                }
                if (c == 'U') {
                    string2 = "URL";
                    n = 36;
                    break;
                }
                if (c != 'a') break;
                string2 = "all";
                n = 3;
                break;
            }
            case 4: {
                switch (string.charAt(0)) {
                    case 'b': {
                        string2 = "body";
                        n = 7;
                        break block0;
                    }
                    case 'h': {
                        string2 = "head";
                        n = 18;
                        break block0;
                    }
                    case 'l': {
                        string2 = "load";
                        n = -21;
                        break block0;
                    }
                    case 'm': {
                        string2 = "maps";
                        n = 26;
                        break block0;
                    }
                    case 'o': {
                        string2 = "open";
                        n = -23;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(2)) {
                    case 'd': {
                        string2 = "width";
                        n = 38;
                        break block0;
                    }
                    case 'e': {
                        string2 = "clear";
                        n = -2;
                        break block0;
                    }
                    case 'i': {
                        string2 = "write";
                        n = -28;
                        break block0;
                    }
                    case 'n': {
                        string2 = "links";
                        n = 24;
                        break block0;
                    }
                    case 'o': {
                        string2 = "close";
                        n = -3;
                        break block0;
                    }
                    case 'r': {
                        string2 = "forms";
                        n = 16;
                        break block0;
                    }
                    case 't': {
                        string2 = "title";
                        n = 35;
                        break block0;
                    }
                    case 'y': {
                        string2 = "async";
                        n = 1;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(0)) {
                    case 'c': {
                        string2 = "cookie";
                        n = 8;
                        break block0;
                    }
                    case 'd': {
                        string2 = "domain";
                        n = 13;
                        break block0;
                    }
                    case 'f': {
                        string2 = "frames";
                        n = 17;
                        break block0;
                    }
                    case 'h': {
                        string2 = "height";
                        n = 19;
                        break block0;
                    }
                    case 'i': {
                        string2 = "images";
                        n = 20;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reason";
                        n = 30;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(0)) {
                    case 'a': {
                        char c = string.charAt(1);
                        if (c == 'n') {
                            string2 = "anchors";
                            n = 4;
                            break block0;
                        }
                        if (c != 'p') break block0;
                        string2 = "applets";
                        n = 5;
                        break block0;
                    }
                    case 'b': {
                        string2 = "bgColor";
                        n = 6;
                        break block0;
                    }
                    case 'd': {
                        string2 = "doctype";
                        n = 11;
                        break block0;
                    }
                    case 'f': {
                        string2 = "fgColor";
                        n = 15;
                        break block0;
                    }
                    case 'l': {
                        string2 = "loadXML";
                        n = -22;
                        break block0;
                    }
                    case 'w': {
                        string2 = "writeln";
                        n = -29;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(4)) {
                    case 'N': {
                        string2 = "nodeName";
                        n = 27;
                        break block0;
                    }
                    case 'T': {
                        string2 = "nodeType";
                        n = 28;
                        break block0;
                    }
                    case 'r': {
                        string2 = "referrer";
                        n = 31;
                        break block0;
                    }
                    case 't': {
                        string2 = "location";
                        n = 25;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'e') {
                    string2 = "errorCode";
                    n = 14;
                    break;
                }
                if (c == 'l') {
                    string2 = "linkColor";
                    n = 23;
                    break;
                }
                if (c != 's') break;
                string2 = "selection";
                n = 32;
                break;
            }
            case 10: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "alinkColor";
                        n = 2;
                        break block0;
                    }
                    case 'g': {
                        string2 = "getBGColor";
                        n = -30;
                        break block0;
                    }
                    case 'i': {
                        string2 = "importNode";
                        n = -20;
                        break block0;
                    }
                    case 'p': {
                        string2 = "parseError";
                        n = 29;
                        break block0;
                    }
                    case 'r': {
                        string2 = "resolveURL";
                        n = -25;
                        break block0;
                    }
                    case 's': {
                        string2 = "setBGColor";
                        n = -31;
                        break block0;
                    }
                    case 'v': {
                        string2 = "vlinkColor";
                        n = 37;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "createEvent";
                    n = -13;
                    break;
                }
                if (c == 'd') {
                    string2 = "defaultView";
                    n = 10;
                    break;
                }
                if (c != 's') break;
                string2 = "styleSheets";
                n = 34;
                break;
            }
            case 12: {
                string2 = "lastModified";
                n = 22;
                break;
            }
            case 13: {
                switch (string.charAt(6)) {
                    case 'C': {
                        string2 = "createComment";
                        n = -7;
                        break block0;
                    }
                    case 'E': {
                        string2 = "createElement";
                        n = -9;
                        break block0;
                    }
                    case 'l': {
                        string2 = "addStyleSheet";
                        n = -1;
                        break block0;
                    }
                    case 'o': {
                        string2 = "transformNode";
                        n = -26;
                        break block0;
                    }
                }
                break;
            }
            case 14: {
                switch (string.charAt(0)) {
                    case 'c': {
                        string2 = "createTextNode";
                        n = -15;
                        break block0;
                    }
                    case 'd': {
                        string2 = "defaultCharset";
                        n = 9;
                        break block0;
                    }
                    case 'g': {
                        string2 = "getElementById";
                        n = -16;
                        break block0;
                    }
                    case 'i': {
                        string2 = "implementation";
                        n = 21;
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                char c = string.charAt(6);
                if (c == 'A') {
                    string2 = "createAttribute";
                    n = -4;
                    break;
                }
                if (c == 'E') {
                    string2 = "createElementNS";
                    n = -10;
                    break;
                }
                if (c != 'n') break;
                string2 = "documentElement";
                n = 12;
                break;
            }
            case 16: {
                string2 = "removeStyleSheet";
                n = -24;
                break;
            }
            case 17: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "createAttributeNS";
                    n = -5;
                    break;
                }
                if (c != 'g') break;
                string2 = "getElementsByName";
                n = -17;
                break;
            }
            case 18: {
                string2 = "createCDATASection";
                n = -6;
                break;
            }
            case 20: {
                string2 = "getElementsByTagName";
                n = -18;
                break;
            }
            case 21: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "createEntityReference";
                    n = -12;
                    break;
                }
                if (c != 't') break;
                string2 = "transformNodeToObject";
                n = -27;
                break;
            }
            case 22: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "createDocumentFragment";
                    n = -8;
                    break;
                }
                if (c != 'g') break;
                string2 = "getElementsByTagNameNS";
                n = -19;
                break;
            }
            case 26: {
                string2 = "createElementWithNameSpace";
                n = -11;
                break;
            }
            case 27: {
                string2 = "createProcessingInstruction";
                n = -14;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

