/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.Nbrs;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

abstract class CSSBox
implements ImageObserver,
Nbrs {
    static final int BOX_INLINE = 0;
    static final int BOX_BLOCK = 1;
    static final int BOX_FLOAT_PLACEHOLDER = 2;
    static final int BOX_DEFAULT = 3;
    protected CSSLayout cssLayout;
    protected CSSBox parentBox;
    protected CSSBox next;
    protected DElement element;
    private static final int tileOptMaxSize = 64;
    private static int tileOptThreshold;
    CSSAttribs css;
    byte dynamic = 0;
    int numBreaks;
    int totalWidth;
    int minWidth;
    int maxWidth;
    int ox;
    int oy;
    int width;
    int height;
    private static Rectangle tmp_rect;

    protected CSSBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout) {
        this.element = dElement;
        this.css = cSSAttribs;
        this.cssLayout = cSSLayout;
    }

    protected CSSBox(CSSLayout cSSLayout) {
        this.cssLayout = cSSLayout;
    }

    void dispose() {
        this.parentBox = null;
        this.cssLayout = null;
        this.next = null;
    }

    protected final boolean setVisibility(byte by) {
        CSSAttribs[] cSSAttribsArray;
        if (this.dynamic > 0 && (cSSAttribsArray = (CSSAttribs[])this.cssLayout.dynamicStyles.get(this.getDomNode())) != null) {
            int n = 0;
            while (n < cSSAttribsArray.length) {
                CSSAttribs cSSAttribs = cSSAttribsArray[n];
                if (cSSAttribs != null && (cSSAttribs.misc & 0x20) != 0) {
                    cSSAttribs.misc = (byte)(cSSAttribs.misc & ~1);
                    cSSAttribs.misc = (byte)(cSSAttribs.misc | by & 1);
                }
                ++n;
            }
        }
        if ((this.css.misc & 0x20) == 0) {
            return false;
        }
        this.css.misc = (byte)(this.css.misc & ~1);
        this.css.misc = (byte)(this.css.misc | by & 1);
        return true;
    }

    void propagateVisibility(byte by, boolean bl) {
        if (bl) {
            this.setVisibility(by);
        }
    }

    void notifyChildrenGenerated() {
    }

    CSSBox getLast() {
        return null;
    }

    void setParentBox(CSSBox cSSBox) {
        this.parentBox = cSSBox;
    }

    final CSSBox getParentBox() {
        return this.parentBox;
    }

    CSSBox getFirstChild() {
        return null;
    }

    int getType() {
        return 3;
    }

    void invalidate() {
        CSSBox cSSBox = this;
        while (cSSBox != null) {
            cSSBox.minWidth = 0;
            cSSBox = cSSBox.parentBox;
        }
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        point.x = n;
        point.y = n2;
        return this;
    }

    void applyDynamicStyle(int n) {
        CSSBox cSSBox = this.parentBox;
        if (cSSBox != null) {
            cSSBox.applyDynamicStyle(n);
        }
    }

    void findAbsolutePosition(Point point) {
        point.x += this.ox;
        point.y += this.oy;
        if (this.parentBox != null) {
            this.parentBox.findAbsolutePosition(point);
        }
    }

    void findAbsolutePosition_int(Point point) {
        this.findAbsolutePosition(point);
    }

    void findBoundingBox(Rectangle rectangle) {
    }

    DNode getDomNode() {
        return null;
    }

    int calcBreaks() {
        return 0;
    }

    int getBreaks(int[] nArray, int n) {
        return 0;
    }

    int getChunkDescentAscent(int n, int n2) {
        return 0;
    }

    void paintChunk(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    void calcMinMaxWidths() {
    }

    void layout(int n, int n2, FloatManager floatManager) {
    }

    void paint(Graphics graphics) {
    }

    CSSBox addChild(CSSBox cSSBox) {
        return this;
    }

    void reqReflow() {
        this.cssLayout.refresh();
    }

    void reqRepaint() {
        if (this.cssLayout != null && this.cssLayout.docPane != null) {
            Rectangle rectangle = new Rectangle();
            this.findBoundingBox(rectangle);
            if (rectangle.width != 0) {
                int n = this.cssLayout.maxOutlineWidth;
                this.cssLayout.docPane.reqRepaint(rectangle.x - n, rectangle.y - n, rectangle.width + 1 + 2 * n, rectangle.height + 1 + 2 * n);
            }
        } else if (Debug.trace) {
            Debug.trace("Could not repaint " + this);
        }
    }

    public String toString() {
        DNode dNode = this.getDomNode();
        String string = "NoNode";
        if (dNode != null) {
            string = dNode.toString();
        }
        return super.toString() + "[" + string + "]";
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Color color = this.css.background_color;
        Image image = null;
        if (this.css.background_image instanceof Image) {
            image = (Image)this.css.background_image;
        }
        if (this.cssLayout.topBox == this && color == null) {
            CSSBox cSSBox = this.getFirstChild();
            if (cSSBox != null) {
                Object object;
                if (image == null && (object = cSSBox.css.background_image) instanceof Image) {
                    image = (Image)object;
                    ThePilot.prepareImage(image, this);
                    cSSBox.css.background_image = null;
                    this.css.background_params = cSSBox.css.background_params;
                    cSSBox.css.background_params = 0;
                    this.css.background_image = image;
                }
                color = cSSBox.css.background_color;
                cSSBox.css.background_color = null;
            }
            if (color == null) {
                color = Color.white;
            }
            this.css.background_color = color;
        }
        int n7 = n3;
        int n8 = rectangle.x - n;
        if (n8 > 0) {
            n = rectangle.x;
            if (rectangle.width < (n3 -= n8)) {
                n3 = rectangle.width;
            }
        } else if (rectangle.width + n8 < n3) {
            n3 = rectangle.width + n8;
        }
        if ((n6 = rectangle.y - n2) > 0) {
            n2 = rectangle.y;
            if (rectangle.height < (n4 -= n6)) {
                n4 = rectangle.height;
            }
        } else if (rectangle.height + n6 < n4) {
            n4 = rectangle.height + n6;
        }
        if (n3 > 0 && n4 > 0) {
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(n, n2, n3, n4);
            }
            if (image != null) {
                this.paintBackgroundImage(graphics, image, n7, n, n2, n3, n4, n5);
            }
        }
    }

    private void paintBackgroundImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        boolean bl;
        int n9 = image.getWidth(this);
        int n10 = image.getHeight(this);
        if (n9 < 1 || n10 < 1) {
            return;
        }
        boolean bl2 = 0 == (this.css.background_params & 1);
        boolean bl3 = bl = 0 == (this.css.background_params & 2);
        if ((n9 < tileOptThreshold || n10 < tileOptThreshold) && this.css.background_params == 0) {
            return;
        }
        if (n9 == 1 && n10 == 1 && bl2 && bl) {
            graphics.drawImage(image, 0, 0, 1, 1, n2, n3, n4, n5, this);
            return;
        }
        int n11 = n9;
        int n12 = n10;
        boolean bl4 = false;
        int n13 = this.cssLayout.getLayoutZoom();
        if (n13 != 256) {
            bl4 = true;
            n8 = n13;
            if (n12 > n11) {
                if (n11 * n8 >> 8 < 64) {
                    n8 = 16384 / n11;
                }
            } else if (n12 * n8 >> 8 < 64) {
                n8 = 16384 / n12;
            }
            n11 = n11 * n8 >> 8;
            n12 = n12 * n8 >> 8;
        }
        n8 = -n2 % n11 + n2;
        int n14 = -n3 % n12 + n3;
        if ((this.css.background_params & 4) != 0) {
            int n15 = 0;
            n7 = 0;
            if (this.cssLayout != null && this.cssLayout.docPane != null) {
                n15 = this.cssLayout.docPane.getScrollX();
                n7 = this.cssLayout.docPane.getScrollY();
            }
            Point point = new Point();
            this.findAbsolutePosition(point);
            if (!bl2 && point.x + n2 - n15 >= n11) {
                return;
            }
            if (!bl && point.y + n3 - n7 >= n12) {
                return;
            }
            point.x = -n15;
            point.y = -n7 - n6;
            this.findAbsolutePosition(point);
            n8 = (-point.x - n2) % n11 + n2;
            n14 = (-point.y - n3) % n12 + n3;
        } else {
            if (!bl2 && n2 >= n11) {
                return;
            }
            if (!bl && n3 >= n12) {
                return;
            }
        }
        Graphics graphics2 = graphics.create(n2, n3, n4, n5);
        if (n10 == 1 && n9 == 1) {
            n7 = n14 - n3;
            int n16 = n8 - n2;
        }
        n7 = n14 - n3;
        while (n7 < n5) {
            int n17 = n8 - n2;
            while (n17 < n4) {
                int n18 = n17;
                if (!bl2) {
                    if ((this.css.background_params & 0x10) != 0) {
                        n18 = n - n11;
                    }
                }
                if (bl4) {
                    graphics2.drawImage(image, n18, n7, n11, n12, this);
                } else {
                    graphics2.drawImage(image, n18, n7, this);
                }
                n17 += n11;
                if (!bl2) break;
            }
            n7 += n12;
            if (!bl) break;
        }
        graphics2.dispose();
    }

    void loadBackgroundImage(DDocument dDocument) {
        boolean bl;
        String string = (String)this.css.background_image;
        String string2 = dDocument.resolveUrl(string);
        Image image = dDocument.getPilot().objectPool.loadImage(string2);
        this.css.background_image = image;
        if (image != null && (bl = Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this))) {
            this.imageUpdate(image, 32, 0, 0, -1, -1);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.cssLayout == null || this.cssLayout.docPane == null) {
            return false;
        }
        if ((n & 0xC0) != 0 || this.css.background_image != image) {
            if (this.css != null) {
                this.css.background_image = null;
                this.reqRepaint();
            }
            return false;
        }
        if ((n & 0x20) != 0) {
            if (this.cssLayout != null && this.cssLayout.docPane != null) {
                Image image2;
                if (this.css != null && (image2 = this.tileImage(image)) != null) {
                    this.css.background_params = (byte)(this.css.background_params | 8);
                    this.css.background_image = image2;
                }
                this.reqRepaint();
            }
            return false;
        }
        if ((n & 0x10) != 0) {
            Image image3 = null;
            if (this.cssLayout != null && this.cssLayout.docPane != null) {
                if (this.css != null && (image3 = this.tileImage(image)) != null) {
                    this.css.background_params = (byte)(this.css.background_params | 8);
                    this.css.background_image = image3;
                }
                this.reqRepaint();
            }
            if (image3 != null || !this.cssLayout.doImageAnimation) {
                return false;
            }
        }
        return true;
    }

    private final Image tileImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        if (n >= tileOptThreshold && n2 >= tileOptThreshold) {
            return null;
        }
        int n3 = 1;
        int n4 = 1;
        if (n < 64) {
            if ((this.css.background_params & 1) == 0) {
                n3 = (64 + n - 1) / n;
            }
        }
        if (n2 < 64) {
            if ((this.css.background_params & 2) == 0) {
                n4 = (64 + n2 - 1) / n2;
            }
        }
        int n5 = n3 * n;
        int n6 = n4 * n2;
        Image image2 = this.cssLayout.docPane.createImage(n5, n6);
        Graphics graphics = image2.getGraphics();
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                graphics.drawImage(image, n8 * n, n7 * n2, null);
                ++n8;
            }
            ++n7;
        }
        graphics.dispose();
        return image2;
    }

    protected void paintBorders(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Color color;
        if (bl && n2 + this.css.border_top_width > rectangle.y && n2 < rectangle.y + rectangle.height) {
            color = this.css.border_top_color;
            if (color == null && (this.css.border_top_style == 154 || this.css.border_top_style == 155)) {
                CSSBox cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_top_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_top_style == 148 || this.css.border_top_style == 149) {
                    graphics.setColor(color);
                    CSSUtil.drawStyledLine(graphics, n, n2, n + n3 - 1, n2, this.css.border_top_style, this.css.border_top_width);
                } else {
                    if (this.css.border_top_style == 154) {
                        color = this.makeDark(color);
                    } else if (this.css.border_top_style == 155) {
                        color = this.makeBright(color);
                    }
                    graphics.setColor(color);
                    int n12 = 0;
                    while (n12 < this.css.border_top_width) {
                        graphics.drawLine(n, n2 + n12, n + n3 - 1, n2 + n12);
                        ++n12;
                    }
                }
            }
        }
        if (bl2 && n2 + n4 > rectangle.y && n2 + n4 - this.css.border_bottom_width < rectangle.y + rectangle.height) {
            color = this.css.border_bottom_color;
            if (color == null && (this.css.border_bottom_style == 154 || this.css.border_bottom_style == 155)) {
                CSSBox cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_bottom_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_bottom_style == 148 || this.css.border_bottom_style == 149) {
                    graphics.setColor(color);
                    int n13 = n2 + n4 - this.css.border_bottom_width;
                    CSSUtil.drawStyledLine(graphics, n, n13, n + n3 - 1, n13, this.css.border_bottom_style, this.css.border_bottom_width);
                } else {
                    if (this.css.border_bottom_style == 154) {
                        color = this.makeBright(color);
                    } else if (this.css.border_bottom_style == 155) {
                        color = this.makeDark(color);
                    }
                    graphics.setColor(color);
                    int n14 = this.css.border_bottom_width;
                    while (n14 > 0) {
                        graphics.drawLine(n, n2 + n4 - n14, n + n3 - 1, n2 + n4 - n14);
                        --n14;
                    }
                }
            }
        }
        if (bl3) {
            color = this.css.border_left_color;
            if (color == null && (this.css.border_left_style == 154 || this.css.border_left_style == 155)) {
                CSSBox cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_left_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_left_style == 148 || this.css.border_left_style == 149) {
                    graphics.setColor(color);
                    CSSUtil.drawStyledLine(graphics, n, n2, n, n2 + n4 - 1, this.css.border_left_style, this.css.border_left_width);
                } else {
                    if (this.css.border_left_style == 154) {
                        color = this.makeDark(color);
                    } else if (this.css.border_left_style == 155) {
                        color = this.makeBright(color);
                    }
                    graphics.setColor(color);
                    int n15 = this.css.border_left_width;
                    n11 = n2;
                    n10 = n2 + n4;
                    if (n11 < rectangle.y - n15) {
                        n11 = rectangle.y - n15;
                    }
                    if (n10 > rectangle.y + rectangle.height + n15) {
                        n10 = rectangle.y + rectangle.height + n15;
                    }
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    if (bl) {
                        n7 = (this.css.border_top_width << 16) / n15;
                    }
                    if (bl2) {
                        n6 = (this.css.border_bottom_width << 16) / n15;
                    }
                    n5 = 0;
                    while (n5 < n15) {
                        graphics.drawLine(n + n5, n11 + (n9 >> 16), n + n5, n10 - (n8 >> 16) - 1);
                        ++n5;
                        n9 += n7;
                        n8 += n6;
                    }
                }
            }
        }
        if (bl4) {
            color = this.css.border_right_color;
            if (color == null && (this.css.border_right_style == 154 || this.css.border_right_style == 155)) {
                CSSBox cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_right_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_right_style == 148 || this.css.border_right_style == 149) {
                    graphics.setColor(color);
                    int n16 = n + n3 - 1 - this.css.border_right_width;
                    CSSUtil.drawStyledLine(graphics, n16, n2, n16, n2 + n4 - 1, this.css.border_right_style, this.css.border_right_width);
                } else {
                    if (this.css.border_right_style == 154) {
                        color = this.makeBright(color);
                    } else if (this.css.border_right_style == 155) {
                        color = this.makeDark(color);
                    }
                    graphics.setColor(color);
                    int n17 = this.css.border_right_width;
                    n11 = n2;
                    n10 = n2 + n4;
                    if (n11 < rectangle.y - n17) {
                        n11 = rectangle.y - n17;
                    }
                    if (n10 > rectangle.y + rectangle.height + n17) {
                        n10 = rectangle.y + rectangle.height + n17;
                    }
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    if (bl) {
                        n7 = (this.css.border_top_width << 16) / n17;
                    }
                    if (bl2) {
                        n6 = (this.css.border_bottom_width << 16) / n17;
                    }
                    n5 = 0;
                    while (n5 < n17) {
                        graphics.drawLine(n + n3 - n5 - 1, n11 + (n9 >> 16), n + n3 - n5 - 1, n10 - (n8 >> 16) - 1);
                        ++n5;
                        n9 += n7;
                        n8 += n6;
                    }
                }
            }
        }
    }

    private final Color makeDark(Color color) {
        if (color.equals(Color.black)) {
            return Color.gray;
        }
        if (color.equals(Color.white)) {
            return Color.gray;
        }
        return color.darker();
    }

    private final Color makeBright(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return Color.lightGray;
        }
        if (n == 255 && n2 == 255 && n3 == 255) {
            return Color.lightGray;
        }
        int n4 = (n << 1) + n >> 1;
        int n5 = (n2 << 1) + n2 >> 1;
        int n6 = (n3 << 1) + n3 >> 1;
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n4 == n && n5 == n2 && n6 == n3) {
            if (n6 == 0) {
                n6 += 128;
                if (n4 == 255 && n5 == 255) {
                    n6 += 127;
                }
            }
            if (n4 == 0) {
                n4 += 128;
            }
            if (n5 == 0) {
                n5 += 128;
            }
        }
        return new Color(n4, n5, n6);
    }

    static {
        String string = "ice.pilots.html4.tileOptThreshold";
        tileOptThreshold = Defs.intProperty(string, 32);
        if (tileOptThreshold < 0) {
            tileOptThreshold = 0;
        } else if (tileOptThreshold > 32) {
            tileOptThreshold = 32;
        }
        tmp_rect = new Rectangle();
    }
}

