/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AccessibleContextProxy;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TheView;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class AccessibleHyperPanel
extends AccessibleContextProxy
implements AccessibleHypertext,
EventListener {
    private AccessibleContext _proxyContext = null;
    private ScreenReaderStatusComponent _statusComponent = null;
    private ThePilot _pilot = null;
    private DDocument _document = null;
    private DElement _body = null;
    private String _fixedAccessibleName = null;
    private String _fixedAccessibleDescription = null;
    private String _documentTitle = null;
    private String _text = "";
    private Vector _lineMap = null;
    private Vector _linkVector = null;
    private Hashtable _namedAnchorTable = null;
    private int _caretPosition = 0;
    private DocumentLine _currentLine = null;
    private static int FAKE_CHAR_WIDTH = 14;
    private static int FAKE_CHAR_HEIGHT = 14;
    private static int FAKE_LINE_LENGTH = 100;
    private String LINK_IDENTIFIER = "LINK";
    private String INPUT_IDENTIFIER = "INPUT";
    private String IMAGE_IDENTIFIER = "IMAGE";
    private String HYPERTEXT_ACCESSIBLE_DESCRIPTION = "HTML Page";

    public AccessibleHyperPanel(ThePilot thePilot, AccessibleContext accessibleContext, ScreenReaderStatusComponent screenReaderStatusComponent) {
        this._proxyContext = accessibleContext;
        this._pilot = thePilot;
        this._statusComponent = screenReaderStatusComponent;
        this._pilot.addPersistentDOMEventListener("load", this, true);
        this._pilot.addPersistentDOMEventListener("unload", this, true);
        this._pilot.addPersistentDOMEventListener("keyup", this, true);
        this._pilot.addPersistentDOMEventListener("focus", this, true);
        this._pilot.addPersistentDOMEventListener("goto", this, true);
        this._lineMap = new Vector();
        this._linkVector = new Vector();
        this._namedAnchorTable = new Hashtable();
        this._buildDocumentData();
    }

    public String getAccessibleName() {
        if (this._fixedAccessibleName != null) {
            return this._fixedAccessibleName;
        }
        return this._documentTitle;
    }

    public void setAccessibleName(String string) {
        String string2 = this.getAccessibleName();
        this._fixedAccessibleName = string;
        this.firePropertyChange("AccessibleName", string2, this.getAccessibleName());
    }

    public String getAccessibleDescription() {
        if (this._fixedAccessibleDescription != null) {
            return this._fixedAccessibleDescription;
        }
        return this.HYPERTEXT_ACCESSIBLE_DESCRIPTION;
    }

    public void setAccessibleDescription(String string) {
        String string2 = this.getAccessibleDescription();
        this._fixedAccessibleDescription = string;
        this.firePropertyChange("AccessibleDescription", string2, this.getAccessibleDescription());
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
        accessibleStateSet.add(AccessibleState.MULTI_LINE);
        return accessibleStateSet;
    }

    public int getLinkCount() {
        return this._linkVector.size();
    }

    public AccessibleHyperlink getLink(int n) {
        DocumentLink documentLink = null;
        if (n >= 0 && n < this._linkVector.size()) {
            documentLink = (DocumentLink)this._linkVector.elementAt(n);
        }
        return documentLink;
    }

    public int getLinkIndex(int n) {
        int n2 = -1;
        if (n >= 0 && n < this._text.length()) {
            int n3 = 0;
            while (n3 < this._linkVector.size()) {
                DocumentLink documentLink = (DocumentLink)this._linkVector.elementAt(n3);
                if (n >= documentLink.getStartIndex() && n < documentLink.getEndIndex()) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    public int getIndexAtPoint(Point point) {
        int n = -1;
        if (point != null && point.x >= 0 && point.y >= 0) {
            int n2 = 0;
            while (n2 < this._lineMap.size()) {
                DocumentLine documentLine = (DocumentLine)this._lineMap.elementAt(n2);
                Rectangle rectangle = documentLine.getLineBounds();
                if (point.y < rectangle.y + rectangle.height) {
                    n = documentLine.getCharacterAtX(point.x);
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public Rectangle getCharacterBounds(int n) {
        Rectangle rectangle = new Rectangle();
        if (n >= 0 && n < this._text.length()) {
            int n2 = 0;
            while (n2 < this._lineMap.size()) {
                DocumentLine documentLine = (DocumentLine)this._lineMap.elementAt(n2);
                if (n < documentLine.getDocumentOffset() + documentLine.getLength()) {
                    rectangle = documentLine.getCharacterBounds(n - documentLine.getDocumentOffset());
                    break;
                }
                ++n2;
            }
        }
        return rectangle;
    }

    public int getCharCount() {
        return this._text.length();
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public String getAtIndex(int n, int n2) {
        if (n2 < 0 || n2 >= this._text.length()) {
            return null;
        }
        switch (n) {
            case 1: {
                return this._text.substring(n2, n2 + 1);
            }
            case 2: 
            case 3: {
                BreakIterator breakIterator = this._getIterator(n);
                breakIterator.setText(this._text);
                int n3 = breakIterator.following(n2);
                return this._text.substring(breakIterator.previous(), n3);
            }
        }
        return null;
    }

    public String getAfterIndex(int n, int n2) {
        if (n == 1) {
            return this.getAtIndex(n, n2 + 1);
        }
        if (n2 < 0 || n2 >= this._text.length()) {
            return null;
        }
        BreakIterator breakIterator = this._getIterator(n);
        breakIterator.setText(this._text);
        int n3 = breakIterator.following(n2);
        if (n3 == -1 || n3 >= this._text.length()) {
            return null;
        }
        int n4 = breakIterator.following(n3);
        if (n4 == -1 || n4 >= this._text.length()) {
            return null;
        }
        return this._text.substring(n3, n4);
    }

    public String getBeforeIndex(int n, int n2) {
        if (n == 1) {
            return this.getAtIndex(n, n2 - 1);
        }
        if (n2 < 0 || n2 >= this._text.length()) {
            return null;
        }
        BreakIterator breakIterator = this._getIterator(n);
        breakIterator.setText(this._text);
        breakIterator.following(n2);
        int n3 = breakIterator.previous();
        int n4 = breakIterator.previous();
        if (n4 == -1) {
            return null;
        }
        return this._text.substring(n4, n3);
    }

    public AttributeSet getCharacterAttribute(int n) {
        return SimpleAttributeSet.EMPTY;
    }

    public int getSelectionStart() {
        if (this._currentLine != null) {
            return this._currentLine.getDocumentOffset();
        }
        return 0;
    }

    public int getSelectionEnd() {
        if (this._currentLine != null) {
            return this._currentLine.getDocumentOffset() + this._currentLine.getLength();
        }
        return this._text.length();
    }

    public AccessibleText getAccessibleText() {
        return this;
    }

    public String getSelectedText() {
        if (this._currentLine != null) {
            return this._currentLine.getLine();
        }
        return this._text;
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        DNode dNode = (DNode)event.getTarget();
        switch (dOMEvent.getTypeId()) {
            case 13: {
                if (dNode == null || dNode.getNameId() != 13) break;
                this._buildDocumentData();
                break;
            }
            case 14: {
                if (dNode == null || dNode.getNameId() != 13) break;
                this._clearDocumentData(true);
                break;
            }
            case 10: {
                DOMUIEvent dOMUIEvent = (DOMUIEvent)event;
                this._handleKeyUpEvent(dOMUIEvent);
                break;
            }
            case 21: {
                if (dNode == null) break;
                this._handleFocusEvent(dNode);
                break;
            }
            case 30: {
                if (dNode == null) break;
                this._handleGotoEvent(dNode);
                break;
            }
        }
    }

    private void _handleGotoEvent(DNode dNode) {
        Object object;
        String string;
        Integer n;
        int n2 = 0;
        if (dNode instanceof DAnchorElement && (n = (Integer)this._namedAnchorTable.get(string = ((DElement)(object = (DAnchorElement)dNode)).getAttribute(63))) != null) {
            n2 = n;
        }
        if (this._lineMap.size() > 0) {
            if (n2 >= this._lineMap.size()) {
                n2 = this._lineMap.size() - 1;
            }
            object = (DocumentLine)this._lineMap.elementAt(n2);
            int n3 = this._caretPosition;
            this._caretPosition = ((DocumentLine)object).getDocumentOffset();
            if (object != this._currentLine) {
                this._currentLine = object;
                this._statusComponent.setScreenReaderStatus(((DocumentLine)object).getLine());
            }
            if (this._caretPosition != n3) {
                this.firePropertyChange("AccessibleCaret", new Integer(n3), new Integer(this._caretPosition));
            }
        }
    }

    private void _handleFocusEvent(DNode dNode) {
        int n = 0;
        while (n < this._lineMap.size()) {
            DocumentLine documentLine = (DocumentLine)this._lineMap.elementAt(n);
            if (documentLine.getNode() == dNode) {
                int n2 = this._caretPosition;
                this._caretPosition = documentLine.getDocumentOffset();
                if (documentLine != this._currentLine) {
                    this._currentLine = documentLine;
                    this._statusComponent.setScreenReaderStatus(documentLine.getLine());
                }
                if (this._caretPosition == n2) break;
                this.firePropertyChange("AccessibleCaret", new Integer(n2), new Integer(this._caretPosition));
                break;
            }
            ++n;
        }
    }

    private void _handleKeyUpEvent(DOMUIEvent dOMUIEvent) {
        if (this._currentLine == null) {
            return;
        }
        int n = this._caretPosition;
        if (dOMUIEvent.getKeyCode() == 39L) {
            if (this._caretPosition < this._text.length()) {
                ++this._caretPosition;
                if (this._caretPosition >= this._currentLine.getDocumentOffset() + this._currentLine.getLength()) {
                    this._currentLine = this._getNextLine(this._currentLine);
                }
            }
        } else if (dOMUIEvent.getKeyCode() == 37L) {
            if (this._caretPosition > 0) {
                --this._caretPosition;
                if (this._caretPosition < this._currentLine.getDocumentOffset()) {
                    this._currentLine = this._getPrevLine(this._currentLine);
                }
            }
        } else if (dOMUIEvent.getKeyCode() == 38L) {
            this._currentLine = this._getPrevLine(this._currentLine);
            this._caretPosition = this._currentLine.getDocumentOffset();
        } else if (dOMUIEvent.getKeyCode() == 40L) {
            if (this._currentLine.getLineNumber() < this._lineMap.size() - 1) {
                this._currentLine = this._getNextLine(this._currentLine);
                this._caretPosition = this._currentLine.getDocumentOffset();
            } else if (this._currentLine.getLineNumber() == this._lineMap.size() - 1) {
                this._caretPosition = this._text.length();
            }
        }
        if (n != this._caretPosition) {
            this._currentLine.requestFocus();
            this.firePropertyChange("AccessibleCaret", new Integer(n), new Integer(this._caretPosition));
        }
    }

    protected AccessibleContext getAccessibleContext() {
        return this._proxyContext;
    }

    private DocumentLine _getPrevLine(DocumentLine documentLine) {
        DocumentLine documentLine2;
        if (documentLine.getLineNumber() > 0 && (documentLine2 = (DocumentLine)this._lineMap.elementAt(documentLine.getLineNumber() - 1)) != null) {
            return documentLine2;
        }
        return documentLine;
    }

    private DocumentLine _getNextLine(DocumentLine documentLine) {
        DocumentLine documentLine2;
        if (documentLine.getLineNumber() < this._lineMap.size() - 1 && (documentLine2 = (DocumentLine)this._lineMap.elementAt(documentLine.getLineNumber() + 1)) != null) {
            return documentLine2;
        }
        return documentLine;
    }

    private synchronized void _buildDocumentData() {
        if (this._body != null) {
            this._clearDocumentData(false);
        }
        this._document = (DDocument)this._pilot.getDocument();
        this._body = (DElement)this._document.getBody();
        this._documentTitle = this._document.getTitle();
        if (this._body == null) {
            this._text = "";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            this._populateDocumentMap(this._body, stringBuffer, this._lineMap, this._linkVector, this._namedAnchorTable);
            this._text = stringBuffer.toString();
        }
        this._caretPosition = 0;
        if (this._lineMap.size() > 0) {
            this._currentLine = (DocumentLine)this._lineMap.elementAt(0);
        }
        this.firePropertyChange("AccessibleName", null, this.getAccessibleName());
        this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
    }

    private synchronized void _clearDocumentData(boolean bl) {
        String string = this.getAccessibleName();
        this._document = (DDocument)this._pilot.getDocument();
        this._body = null;
        this._documentTitle = null;
        this._lineMap.removeAllElements();
        int n = 0;
        while (n < this._linkVector.size()) {
            DocumentLink documentLink = (DocumentLink)this._linkVector.elementAt(n);
            documentLink.setValid(false);
            ++n;
        }
        this._linkVector.removeAllElements();
        this._namedAnchorTable.clear();
        this._text = "";
        this._currentLine = null;
        this._caretPosition = 0;
        if (bl) {
            this.firePropertyChange("AccessibleName", string, this.getAccessibleName());
            this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private BreakIterator _getIterator(int n) {
        if (n == 2) {
            return BreakIterator.getWordInstance(this.getLocale());
        }
        return BreakIterator.getSentenceInstance(this.getLocale());
    }

    private void _populateDocumentMap(DNode dNode, StringBuffer stringBuffer, Vector vector, Vector vector2, Hashtable hashtable) {
        if (dNode == null) {
            return;
        }
        if (dNode instanceof DTextNode) {
            this._handleTextNode((DTextNode)dNode, stringBuffer, vector);
        } else {
            if (dNode instanceof DImageElement) {
                this._handleImageNode((DImageElement)dNode, stringBuffer, vector);
                return;
            }
            if (dNode instanceof DInputElement) {
                this._handleInputNode((DInputElement)dNode, stringBuffer, vector);
                return;
            }
            if (dNode instanceof DAnchorElement) {
                this._handleLinkNode((DAnchorElement)dNode, stringBuffer, vector, vector2, hashtable);
                return;
            }
        }
        DNode dNode2 = (DNode)dNode.getFirstChild();
        while (dNode2 != null) {
            this._populateDocumentMap(dNode2, stringBuffer, vector, vector2, hashtable);
            dNode2 = (DNode)dNode2.getNextSibling();
        }
    }

    private void _handleImageNode(DImageElement dImageElement, StringBuffer stringBuffer, Vector vector) {
        if (dImageElement != null) {
            Object object;
            Object object2;
            String string = dImageElement.getAlt();
            if (string == null && (object2 = (DNode)dImageElement.getParentNode()) != null && object2 instanceof DAnchorElement && (object = dImageElement.getSrc()) != null) {
                string = object;
            }
            if (string != null && string.length() > 0) {
                object2 = this.IMAGE_IDENTIFIER + " " + string;
                object = new DocumentLine(dImageElement, (String)object2, vector.size(), stringBuffer.length());
                vector.addElement(object);
                stringBuffer.append(((DocumentLine)object).getLine());
            }
        }
    }

    private void _handleInputNode(DInputElement dInputElement, StringBuffer stringBuffer, Vector vector) {
        if (dInputElement != null) {
            String string = dInputElement.getType();
            String string2 = dInputElement.getAlt();
            String string3 = this.INPUT_IDENTIFIER + " " + string;
            if (string2 != null) {
                string3 = string3 + " " + string2;
            }
            DocumentLine documentLine = new DocumentLine(dInputElement, string3, vector.size(), stringBuffer.length());
            vector.addElement(documentLine);
            stringBuffer.append(documentLine.getLine());
        }
    }

    private void _handleTextNode(DTextNode dTextNode, StringBuffer stringBuffer, Vector vector) {
        BreakIterator breakIterator = BreakIterator.getLineInstance(this.getLocale());
        String string = dTextNode.getData();
        while (string.length() > 0) {
            int n = 0;
            int n2 = string.length();
            if (string.length() > FAKE_LINE_LENGTH) {
                breakIterator.setText(string);
                n2 = breakIterator.following(FAKE_LINE_LENGTH);
                n = breakIterator.previous();
                if (n == -1) {
                    n = 0;
                }
                if (n2 == -1) {
                    n2 = string.length();
                }
            }
            String string2 = "";
            if (n == 0) {
                string2 = string.substring(0, n2);
                string = string.substring(n2);
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n);
            }
            char c = '\u00a0';
            string2 = string2.replace(c, ' ');
            string2 = string2.trim();
            if (string2.length() == 1) {
                string2 = string2 + " ";
            }
            if (string2.length() <= 0) continue;
            vector.addElement(new DocumentLine(dTextNode, string2, vector.size(), stringBuffer.length()));
            stringBuffer.append(string2);
        }
    }

    private void _handleLinkNode(DAnchorElement dAnchorElement, StringBuffer stringBuffer, Vector vector, Vector vector2, Hashtable hashtable) {
        if (dAnchorElement != null) {
            Object object;
            DocumentLink documentLink = new DocumentLink(dAnchorElement, stringBuffer.length());
            if (documentLink.getHREF() != null) {
                vector2.addElement(documentLink);
                object = new DocumentLine(dAnchorElement, documentLink.getLinkText(), vector.size(), stringBuffer.length());
                vector.addElement(object);
                stringBuffer.append(((DocumentLine)object).getLine());
            }
            if ((object = documentLink.getName()) != null) {
                hashtable.put(object, new Integer(vector.size()));
            }
        }
    }

    public class DocumentLink
    extends AccessibleHyperlink {
        private DAnchorElement _linkElement = null;
        private int _documentOffset = 0;
        private String _linkText = "";
        private URL _linkURL = null;
        private boolean _isValid = true;

        public DocumentLink(DAnchorElement dAnchorElement, int n) {
            this._linkElement = dAnchorElement;
            this._documentOffset = n;
            this._isValid = true;
            try {
                this._linkURL = AccessibleHyperPanel.this._document.resolveURL(this._linkElement.getHref());
            }
            catch (Exception exception) {
                this._linkURL = null;
            }
            this._populateLinkText();
        }

        public String getLinkText() {
            return this._linkText;
        }

        public String getHREF() {
            return this._linkElement.getAttribute(46);
        }

        public String getName() {
            return this._linkElement.getAttribute(63);
        }

        public URL getLinkURL() {
            return this._linkURL;
        }

        public void setValid(boolean bl) {
            this._isValid = bl;
        }

        public boolean isValid() {
            return this._isValid;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0 && this.isValid()) {
                this._linkElement.click();
                return true;
            }
            return false;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0 && this.isValid()) {
                return this._linkText;
            }
            return null;
        }

        public Object getAccessibleActionObject(int n) {
            if (n == 0 && this.isValid()) {
                return this._linkURL;
            }
            return null;
        }

        public Object getAccessibleActionAnchor(int n) {
            return this.getAccessibleActionDescription(n);
        }

        public int getStartIndex() {
            return this._documentOffset;
        }

        public int getEndIndex() {
            return this._documentOffset + this._linkText.length();
        }

        private void _populateLinkText() {
            Vector vector = new Vector();
            StringBuffer stringBuffer = new StringBuffer("");
            Hashtable hashtable = new Hashtable();
            DNode dNode = (DNode)this._linkElement.getFirstChild();
            while (dNode != null) {
                AccessibleHyperPanel.this._populateDocumentMap(dNode, stringBuffer, vector, vector, hashtable);
                dNode = (DNode)dNode.getNextSibling();
            }
            vector.removeAllElements();
            this._linkText = AccessibleHyperPanel.this.LINK_IDENTIFIER + " " + stringBuffer.toString();
        }
    }

    private class DocumentLine {
        private DNode _node = null;
        private String _line = null;
        private int _lineNumber = 0;
        private int _documentOffset = 0;

        public DocumentLine(DNode dNode, String string) {
            this._node = dNode;
            this._line = string;
        }

        public DocumentLine(DNode dNode, String string, int n, int n2) {
            this._node = dNode;
            this._line = string;
            this._lineNumber = n;
            this._documentOffset = n2;
        }

        public String getLine() {
            return this._line;
        }

        public int getLength() {
            return this._line.length();
        }

        public DNode getNode() {
            return this._node;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getDocumentOffset() {
            return this._documentOffset;
        }

        public void setLineNumber(int n) {
            this._lineNumber = n;
        }

        public void setDocumentOffset(int n) {
            this._documentOffset = n;
        }

        public void requestFocus() {
            TheView theView = (TheView)AccessibleHyperPanel.this._document.getDefaultView();
            if (theView != null) {
                if (this._node instanceof DElement) {
                    theView.processFocusCall((DElement)this._node);
                } else {
                    theView.processBlurCall(this._node);
                }
            }
        }

        public Rectangle getLineBounds() {
            Rectangle rectangle = new Rectangle();
            rectangle.setSize(FAKE_CHAR_WIDTH * this._line.length(), FAKE_CHAR_HEIGHT);
            rectangle.setLocation(0, this._lineNumber * FAKE_CHAR_HEIGHT);
            return rectangle;
        }

        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle = new Rectangle();
            if (n >= 0 && n < this._line.length()) {
                rectangle.setSize(FAKE_CHAR_WIDTH, FAKE_CHAR_HEIGHT);
                rectangle.setLocation(n * FAKE_CHAR_WIDTH, this._lineNumber * FAKE_CHAR_HEIGHT);
            }
            return rectangle;
        }

        public int getCharacterAtX(int n) {
            int n2 = n / FAKE_CHAR_WIDTH;
            if (n2 > this._line.length()) {
                n2 = -1;
            }
            return n2;
        }
    }
}

