/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.PrintComponent;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;

public class PrintPreview
extends Dialog
implements WindowListener,
ActionListener,
ItemListener,
Runnable {
    private PrintComponent c;
    private Button done;
    private Button nextPage;
    private Button prevPage;
    private Button printButton;
    private Choice zoomCombo;
    private Pilot pilot;
    private StormPrinter printer;
    private Thread printerThread;
    private Frame frame;
    private int zoom = 256;
    private Properties props = new Properties();
    private int PAGE_WIDTH = 570;
    private int PAGE_HEIGHT = 750;

    public PrintPreview(Frame frame, StormBase stormBase, String string) {
        super(frame, "Print preview - " + string, true);
        this.frame = frame;
        this.addWindowListener(this);
        this.done = new Button("done");
        this.done.addActionListener(this);
        this.nextPage = new Button("next page");
        this.nextPage.addActionListener(this);
        this.prevPage = new Button("prev page");
        this.prevPage.addActionListener(this);
        this.printButton = new Button("print");
        this.printButton.addActionListener(this);
        this.zoomCombo = new Choice();
        this.zoomCombo.add("25%");
        this.zoomCombo.add("50%");
        this.zoomCombo.add("75%");
        this.zoomCombo.add("100%");
        this.zoomCombo.add("200%");
        this.zoomCombo.add("400%");
        this.zoomCombo.select(3);
        this.zoomCombo.addItemListener(this);
        Viewport viewport = stormBase.findViewportByName(string);
        this.pilot = viewport.getPilot();
        this.printer = this.pilot.createPrinter();
        this.printer.setPageSize(this.PAGE_WIDTH, this.PAGE_HEIGHT);
        this.printer.setZoom(this.zoom);
        this.printer.layoutNextPage();
        this.c = new PrintComponent(this.printer, this.PAGE_WIDTH, this.PAGE_HEIGHT);
        Panel panel = new Panel();
        panel.add(this.printButton);
        panel.add(this.nextPage);
        panel.add(this.zoomCombo);
        panel.add(this.done);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        this.add((Component)this.c, "Center");
        ((Component)this).setSize(620, 850);
        Point point = frame.getLocation();
        ((Component)this).setLocation(point.x + 10, point.y + 10);
    }

    public void dispose() {
        if (this.printer != null) {
            this.printer.dispose();
        }
        super.dispose();
    }

    public void run() {
        StormPrinter stormPrinter = this.pilot.createPrinter();
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this.frame, "ib5", this.props);
        Dimension dimension = printJob.getPageDimension();
        stormPrinter.setPageSize(dimension.width - 10, dimension.height - 10);
        stormPrinter.setZoom(this.zoom);
        int n = 1;
        while (stormPrinter.layoutNextPage()) {
            Graphics graphics = printJob.getGraphics();
            stormPrinter.printPage(graphics);
            graphics.dispose();
            ++n;
        }
        printJob.end();
        stormPrinter.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.done) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.nextPage) {
            this.printer.layoutNextPage();
            this.c.repaint();
        } else if (actionEvent.getSource() == this.printButton && this.printerThread == null) {
            this.printerThread = new Thread((Runnable)this, "printer-thread");
            this.printerThread.start();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.zoomCombo) {
            int n = this.zoomCombo.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.zoom = 64;
                    break;
                }
                case 1: {
                    this.zoom = 128;
                    break;
                }
                case 2: {
                    this.zoom = 196;
                    break;
                }
                case 3: {
                    this.zoom = 256;
                    break;
                }
                case 4: {
                    this.zoom = 512;
                    break;
                }
                case 5: {
                    this.zoom = 1024;
                }
            }
            this.printer.setZoom(this.zoom);
            this.printer.layoutNextPage();
            this.c.repaint();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

