/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.util.Defs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParseTreePrinter
implements Runnable,
PropertyChangeListener {
    private OutputStream output;
    private DDocument doc;

    ParseTreePrinter(String string) {
        try {
            if (string == null) {
                File file = new File(Defs.sysProperty("user.dir"));
                this.output = new FileOutputStream(new File(file, "ice_output.txt"));
            } else {
                this.output = new FileOutputStream(string);
            }
        }
        catch (Exception exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            if (Debug.trace) {
                Debug.trace("Cannot create file for parse tree output...aborting");
            }
            this.output = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Pilot pilot;
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        if (viewport.getParent() != null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (string.equals("contentLoading") && object instanceof String && ((String)object).equals("end") && (pilot = viewport.getPilot()) instanceof ThePilot) {
            ThePilot thePilot = (ThePilot)pilot;
            this.doc = (DDocument)thePilot.getDocument();
            new Thread(this).start();
        }
    }

    public void run() {
        if (this.output != null) {
            DElement dElement = (DElement)this.doc.getDocumentElement();
            this.writeln("", false);
            this.writeln("******************", false);
            this.writeln("Document source is " + this.doc.getURL(), false);
            this.writeln("******************", false);
            this.writeln("", false);
            this.printAll(dElement, 0);
        }
    }

    private void writeln(String string, boolean bl) {
        if (bl) {
            string = string.toUpperCase();
        }
        try {
            this.output.write((string + "\n").getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printAll(DElement dElement, int n) {
        Node node;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        String string = stringBuffer.toString();
        String string2 = dElement.getNodeName();
        String string3 = "";
        NamedNodeMap namedNodeMap = dElement.getAttributes();
        int n3 = 0;
        while (n3 < namedNodeMap.getLength()) {
            node = (Attr)namedNodeMap.item(n3);
            string3 = string3 + " " + node.getName() + "=\"" + node.getValue() + "\"";
            ++n3;
        }
        this.writeln(string + "<" + string2 + string3 + ">", true);
        node = (DNode)dElement.getFirstChild();
        while (node != null) {
            if (node instanceof DElement) {
                this.printAll((DElement)node, n + 1);
            } else if (node instanceof DTextNode) {
                this.writeln(string + "  " + node, false);
            }
            node = (DNode)((DNode)node).getNextSibling();
        }
        this.writeln(string + "</" + string2 + ">", true);
    }
}

