/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.util.Defs;
import java.awt.Container;

public abstract class CallbackImplBase
implements ViewportCallback,
ScripterCallback {
    StormBase base;
    private boolean reportScriptExceptions;

    public void init(StormBase stormBase) {
        this.base = stormBase;
    }

    public void processViewportMessage(Viewport viewport, String string, Object object, Object object2) {
    }

    public boolean allowScriptClose(Viewport viewport, boolean bl) {
        if (!bl) {
            return this.showConfirmation(viewport, "Script Request Conformation", "Close the window as requested by script code?");
        }
        return true;
    }

    public long getMaxScriptRunningTime() {
        return Defs.sysPropertyInt("ice.scripters.timelimit", 5000);
    }

    public boolean interruptLongRunningScript(Viewport viewport, long l) {
        return this.showConfirmation(viewport, "Script Problem", "Long running script is detected (run time = " + l + " ms). Terminate it?");
    }

    public void reportScriptError(Viewport viewport, boolean bl, String string, String string2, int n, String string3, int n2) {
        String string4 = bl ? "SCRIPT WARNING" : "SCRIPT ERROR";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(':');
        stringBuffer.append(n + 1);
        stringBuffer.append(':');
        stringBuffer.append(n2);
        stringBuffer.append(": ");
        stringBuffer.append(string);
        if (string3 != null) {
            stringBuffer.append('\n');
            stringBuffer.append(string3);
            stringBuffer.append('\n');
            int n3 = 0;
            while (n3 < n2 - 1) {
                stringBuffer.append('.');
                ++n3;
            }
            stringBuffer.append('^');
        }
        String string5 = stringBuffer.toString();
        if (Debug.trace) {
            Debug.trace(string4 + ": " + string5);
        }
        if (this.reportScriptExceptions) {
            this.showMessage(viewport, string4, string5);
        }
    }

    public void scriptAlert(Viewport viewport, String string) {
        this.showMessage(viewport, "Script Alert", string);
    }

    public boolean scriptConfirm(Viewport viewport, String string) {
        return this.showConfirmation(viewport, "Script Confirm", string);
    }

    public String scriptPrompt(Viewport viewport, String string, String string2) {
        return this.showPrompt(viewport, "Script Prompt", string, string2);
    }

    public void scriptPrint(Viewport viewport) {
        if (Debug.trace) {
            Debug.trace("window.print is called from script");
        }
    }

    abstract void showMessage(Viewport var1, String var2, String var3);

    abstract boolean showConfirmation(Viewport var1, String var2, String var3);

    abstract String showPrompt(Viewport var1, String var2, String var3, String var4);

    public abstract void disposeTopLevelContainer(Viewport var1);

    public abstract Container createTopLevelContainer(Viewport var1);
}

