/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.Main;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class BrowserDialog_swing
extends JDialog
implements WindowListener,
PropertyChangeListener {
    private StormBase base;
    private String viewportId;
    private JPanel panel;
    private JLabel status;

    public BrowserDialog_swing(StormBase stormBase, Viewport viewport) {
        this.base = stormBase;
        this.viewportId = viewport.getId();
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.base.addPropertyChangeListener(this, this.viewportId);
        Font font = new Font("SansSerif", 0, 11);
        this.status = new JLabel("");
        this.status.setFont(font);
        this.status.setForeground(Color.black);
        int n = Main.reqWidth;
        int n2 = Main.reqHeight;
        int n3 = -1;
        int n4 = -1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        ViewportGuiParams viewportGuiParams = viewport.getGuiParams();
        if (viewportGuiParams != null) {
            if (viewportGuiParams.width >= 0) {
                n = viewportGuiParams.width + 4;
            }
            if (viewportGuiParams.height >= 0) {
                n2 = viewportGuiParams.height + 28;
            }
            n3 = viewportGuiParams.left;
            n4 = viewportGuiParams.top;
            bl = viewportGuiParams.resizable;
            bl2 = viewportGuiParams.modal;
            bl3 = viewportGuiParams.status;
        }
        if (bl3) {
            this.getContentPane().add((Component)this.status, "South");
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.panel, "Center");
        ((Component)this).setSize(n, n2);
        if (n3 >= 0 && n4 >= 0) {
            ((Component)this).setLocation(n3, n4);
        }
        if (!bl) {
            this.setResizable(false);
        }
        if (bl2) {
            this.setModal(true);
        }
    }

    JPanel getPanel() {
        return this.panel;
    }

    private void updateProgress(String string, int n, int n2) {
        if (n2 > 0) {
            this.status.setText("loading " + string + " (" + n * 100 / n2 + "%)");
        } else {
            this.status.setText("loading " + string + " (" + n + " bytes)");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        boolean bl = viewport.getId().equals(this.viewportId);
        String string = propertyChangeEvent.getPropertyName();
        String string2 = propertyChangeEvent.getNewValue().toString();
        if (bl && string.equals("title")) {
            this.setTitle("Dialog - " + viewport.getName() + " - " + string2);
        } else if (string.equals("statusLine")) {
            this.status.setText(string2);
        } else if (string.equals("contentLoadingProgress")) {
            try {
                int n = string2.indexOf(32);
                int n2 = string2.indexOf(32, n + 1);
                int n3 = Integer.parseInt(string2.substring(n + 1, n2));
                int n4 = Integer.parseInt(string2.substring(n2 + 1));
                this.updateProgress(string2.substring(0, n), n3, n4);
            }
            catch (Exception exception) {}
        } else if (string.equals("outstandingImages")) {
            if (string2.equals("0")) {
                this.status.setText("loading images: done");
            } else {
                this.status.setText("loading images: " + string2 + " left");
            }
        } else if (string.equals("contentLoading") && string2.equals("error")) {
            ContentLoader contentLoader = (ContentLoader)propertyChangeEvent.getOldValue();
            if (contentLoader != null) {
                this.status.setText(viewport.getName() + ": " + contentLoader.getException());
            } else {
                this.status.setText(viewport.getName() + ": loading error");
            }
        } else if (!string.equals("contentRendering")) {
            this.status.setText(viewport.getName() + ": " + string + " " + string2);
        }
        if (string.equals("viewport") && !this.isShowing()) {
            ((Component)this).setVisible(true);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.base.closeViewport(this.viewportId);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

